<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Desativar ServiceType
 * @subpackage Services
 */
class Desativar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Desativar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Desativar $parameters
     * @return \StructType\DesativarResponse|bool
     */
    public function Desativar(\StructType\Desativar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Desativar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * DesativarConfiguracoesConfiguracaoHistorico
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesativarConfiguracoesConfiguracaoHistorico $parameters
     * @return \StructType\DesativarConfiguracoesConfiguracaoHistoricoResponse|bool
     */
    public function DesativarConfiguracoesConfiguracaoHistorico(\StructType\DesativarConfiguracoesConfiguracaoHistorico $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesativarConfiguracoesConfiguracaoHistorico($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DesativarConfiguracoesTransmissao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesativarConfiguracoesTransmissao $parameters
     * @return \StructType\DesativarConfiguracoesTransmissaoResponse|bool
     */
    public function DesativarConfiguracoesTransmissao(\StructType\DesativarConfiguracoesTransmissao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesativarConfiguracoesTransmissao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DesativarConfiguracoesOpcoesSe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesativarConfiguracoesOpcoesSe $parameters
     * @return \StructType\DesativarConfiguracoesOpcoesSeResponse|bool
     */
    public function DesativarConfiguracoesOpcoesSe(\StructType\DesativarConfiguracoesOpcoesSe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesativarConfiguracoesOpcoesSe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DesativarConfiguracoesTransicao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesativarConfiguracoesTransicao $parameters
     * @return \StructType\DesativarConfiguracoesTransicaoResponse|bool
     */
    public function DesativarConfiguracoesTransicao(\StructType\DesativarConfiguracoesTransicao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesativarConfiguracoesTransicao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DesativarConfiguracoesTemperatura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesativarConfiguracoesTemperatura $parameters
     * @return \StructType\DesativarConfiguracoesTemperaturaResponse|bool
     */
    public function DesativarConfiguracoesTemperatura(\StructType\DesativarConfiguracoesTemperatura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesativarConfiguracoesTemperatura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DesativarConfiguracoesInterativo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesativarConfiguracoesInterativo $parameters
     * @return \StructType\DesativarConfiguracoesInterativoResponse|bool
     */
    public function DesativarConfiguracoesInterativo(\StructType\DesativarConfiguracoesInterativo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesativarConfiguracoesInterativo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DesativarConfiguracoesSenhas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesativarConfiguracoesSenhas $parameters
     * @return \StructType\DesativarConfiguracoesSenhasResponse|bool
     */
    public function DesativarConfiguracoesSenhas(\StructType\DesativarConfiguracoesSenhas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesativarConfiguracoesSenhas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DesativarConfiguracoesAtuadores
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesativarConfiguracoesAtuadores $parameters
     * @return \StructType\DesativarConfiguracoesAtuadoresResponse|bool
     */
    public function DesativarConfiguracoesAtuadores(\StructType\DesativarConfiguracoesAtuadores $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesativarConfiguracoesAtuadores($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * DesativarConfiguracoesOpcoesSeguranca
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesativarConfiguracoesOpcoesSeguranca $parameters
     * @return \StructType\DesativarConfiguracoesOpcoesSegurancaResponse|bool
     */
    public function DesativarConfiguracoesOpcoesSeguranca(\StructType\DesativarConfiguracoesOpcoesSeguranca $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesativarConfiguracoesOpcoesSeguranca($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DesativarConfiguracoesExcecao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesativarConfiguracoesExcecao $parameters
     * @return \StructType\DesativarConfiguracoesExcecaoResponse|bool
     */
    public function DesativarConfiguracoesExcecao(\StructType\DesativarConfiguracoesExcecao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesativarConfiguracoesExcecao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * DesativarConfiguracoesMultiplosSensores
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesativarConfiguracoesMultiplosSensores $parameters
     * @return \StructType\DesativarConfiguracoesMultiplosSensoresResponse|bool
     */
    public function DesativarConfiguracoesMultiplosSensores(\StructType\DesativarConfiguracoesMultiplosSensores $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesativarConfiguracoesMultiplosSensores($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DesativarConfiguracoesUmidade
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesativarConfiguracoesUmidade $parameters
     * @return \StructType\DesativarConfiguracoesUmidadeResponse|bool
     */
    public function DesativarConfiguracoesUmidade(\StructType\DesativarConfiguracoesUmidade $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesativarConfiguracoesUmidade($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DesativarConfiguracoesAtuadoresResponse|\StructType\DesativarConfiguracoesConfiguracaoHistoricoResponse|\StructType\DesativarConfiguracoesExcecaoResponse|\StructType\DesativarConfiguracoesInterativoResponse|\StructType\DesativarConfiguracoesMultiplosSensoresResponse|\StructType\DesativarConfiguracoesOpcoesSegurancaResponse|\StructType\DesativarConfiguracoesOpcoesSeResponse|\StructType\DesativarConfiguracoesSenhasResponse|\StructType\DesativarConfiguracoesTemperaturaResponse|\StructType\DesativarConfiguracoesTransicaoResponse|\StructType\DesativarConfiguracoesTransmissaoResponse|\StructType\DesativarConfiguracoesUmidadeResponse|\StructType\DesativarResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
