<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Criar ServiceType
 * @subpackage Services
 */
class Criar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CriarPerfilAlvo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarPerfilAlvo $parameters
     * @return \StructType\CriarPerfilAlvoResponse|bool
     */
    public function CriarPerfilAlvo(\StructType\CriarPerfilAlvo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarPerfilAlvo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarConfiguracoesOpcoesSeguranca
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarConfiguracoesOpcoesSeguranca $parameters
     * @return \StructType\CriarConfiguracoesOpcoesSegurancaResponse|bool
     */
    public function CriarConfiguracoesOpcoesSeguranca(\StructType\CriarConfiguracoesOpcoesSeguranca $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarConfiguracoesOpcoesSeguranca($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CriarConfiguracoesConfiguracaoHistorico
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarConfiguracoesConfiguracaoHistorico $parameters
     * @return \StructType\CriarConfiguracoesConfiguracaoHistoricoResponse|bool
     */
    public function CriarConfiguracoesConfiguracaoHistorico(\StructType\CriarConfiguracoesConfiguracaoHistorico $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarConfiguracoesConfiguracaoHistorico($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarConfiguracoesExcecao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarConfiguracoesExcecao $parameters
     * @return \StructType\CriarConfiguracoesExcecaoResponse|bool
     */
    public function CriarConfiguracoesExcecao(\StructType\CriarConfiguracoesExcecao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarConfiguracoesExcecao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarConfiguracoesExcecaoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarConfiguracoesExcecaoXML $parameters
     * @return \StructType\CriarConfiguracoesExcecaoXMLResponse|bool
     */
    public function CriarConfiguracoesExcecaoXML(\StructType\CriarConfiguracoesExcecaoXML $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarConfiguracoesExcecaoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarConfiguracoesAtuadores
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarConfiguracoesAtuadores $parameters
     * @return \StructType\CriarConfiguracoesAtuadoresResponse|bool
     */
    public function CriarConfiguracoesAtuadores(\StructType\CriarConfiguracoesAtuadores $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarConfiguracoesAtuadores($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarConfiguracoesInterativo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarConfiguracoesInterativo $parameters
     * @return \StructType\CriarConfiguracoesInterativoResponse|bool
     */
    public function CriarConfiguracoesInterativo(\StructType\CriarConfiguracoesInterativo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarConfiguracoesInterativo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarConfiguracoesSenhas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarConfiguracoesSenhas $parameters
     * @return \StructType\CriarConfiguracoesSenhasResponse|bool
     */
    public function CriarConfiguracoesSenhas(\StructType\CriarConfiguracoesSenhas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarConfiguracoesSenhas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarConfiguracoesTemperatura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarConfiguracoesTemperatura $parameters
     * @return \StructType\CriarConfiguracoesTemperaturaResponse|bool
     */
    public function CriarConfiguracoesTemperatura(\StructType\CriarConfiguracoesTemperatura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarConfiguracoesTemperatura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarConfiguracoesTransicao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarConfiguracoesTransicao $parameters
     * @return \StructType\CriarConfiguracoesTransicaoResponse|bool
     */
    public function CriarConfiguracoesTransicao(\StructType\CriarConfiguracoesTransicao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarConfiguracoesTransicao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarConfiguracoesOpcoesSe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarConfiguracoesOpcoesSe $parameters
     * @return \StructType\CriarConfiguracoesOpcoesSeResponse|bool
     */
    public function CriarConfiguracoesOpcoesSe(\StructType\CriarConfiguracoesOpcoesSe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarConfiguracoesOpcoesSe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarConfguracoesTransmissao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarConfguracoesTransmissao $parameters
     * @return \StructType\CriarConfguracoesTransmissaoResponse|bool
     */
    public function CriarConfguracoesTransmissao(\StructType\CriarConfguracoesTransmissao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarConfguracoesTransmissao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarPerfilCerca
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarPerfilCerca $parameters
     * @return \StructType\CriarPerfilCercaResponse|bool
     */
    public function CriarPerfilCerca(\StructType\CriarPerfilCerca $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarPerfilCerca($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarPerfilRota
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarPerfilRota $parameters
     * @return \StructType\CriarPerfilRotaResponse|bool
     */
    public function CriarPerfilRota(\StructType\CriarPerfilRota $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarPerfilRota($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarModTransicao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarModTransicao $parameters
     * @return \StructType\CriarModTransicaoResponse|bool
     */
    public function CriarModTransicao(\StructType\CriarModTransicao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarModTransicao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CriarConfiguracoesMultiplosSensores
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarConfiguracoesMultiplosSensores $parameters
     * @return \StructType\CriarConfiguracoesMultiplosSensoresResponse|bool
     */
    public function CriarConfiguracoesMultiplosSensores(\StructType\CriarConfiguracoesMultiplosSensores $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarConfiguracoesMultiplosSensores($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CriarCfgMultiplosSensoresComNomePerfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarCfgMultiplosSensoresComNomePerfil $parameters
     * @return \StructType\CriarCfgMultiplosSensoresComNomePerfilResponse|bool
     */
    public function CriarCfgMultiplosSensoresComNomePerfil(\StructType\CriarCfgMultiplosSensoresComNomePerfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarCfgMultiplosSensoresComNomePerfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarConfiguracoesUmidade
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarConfiguracoesUmidade $parameters
     * @return \StructType\CriarConfiguracoesUmidadeResponse|bool
     */
    public function CriarConfiguracoesUmidade(\StructType\CriarConfiguracoesUmidade $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarConfiguracoesUmidade($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarVeiculoSensor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarVeiculoSensor $parameters
     * @return \StructType\CriarVeiculoSensorResponse|bool
     */
    public function CriarVeiculoSensor(\StructType\CriarVeiculoSensor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarVeiculoSensor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarTesteComunicacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarTesteComunicacao $parameters
     * @return \StructType\CriarTesteComunicacaoResponse|bool
     */
    public function CriarTesteComunicacao(\StructType\CriarTesteComunicacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarTesteComunicacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarCfgIntervaloPosicaoAutomatica
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarCfgIntervaloPosicaoAutomatica $parameters
     * @return \StructType\CriarCfgIntervaloPosicaoAutomaticaResponse|bool
     */
    public function CriarCfgIntervaloPosicaoAutomatica(\StructType\CriarCfgIntervaloPosicaoAutomatica $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarCfgIntervaloPosicaoAutomatica($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarGrupoFuncaoProgramavel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarGrupoFuncaoProgramavel $parameters
     * @return \StructType\CriarGrupoFuncaoProgramavelResponse|bool
     */
    public function CriarGrupoFuncaoProgramavel(\StructType\CriarGrupoFuncaoProgramavel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarGrupoFuncaoProgramavel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarFuncaoProgramada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarFuncaoProgramada $parameters
     * @return \StructType\CriarFuncaoProgramadaResponse|bool
     */
    public function CriarFuncaoProgramada(\StructType\CriarFuncaoProgramada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarFuncaoProgramada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CriarRegra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarRegra $parameters
     * @return \StructType\CriarRegraResponse|bool
     */
    public function CriarRegra(\StructType\CriarRegra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarRegra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CriarSolicitacaoEspelhamentoReverso
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CriarSolicitacaoEspelhamentoReverso $parameters
     * @return \StructType\CriarSolicitacaoEspelhamentoReversoResponse|bool
     */
    public function CriarSolicitacaoEspelhamentoReverso(\StructType\CriarSolicitacaoEspelhamentoReverso $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CriarSolicitacaoEspelhamentoReverso($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CriarCfgIntervaloPosicaoAutomaticaResponse|\StructType\CriarCfgMultiplosSensoresComNomePerfilResponse|\StructType\CriarConfguracoesTransmissaoResponse|\StructType\CriarConfiguracoesAtuadoresResponse|\StructType\CriarConfiguracoesConfiguracaoHistoricoResponse|\StructType\CriarConfiguracoesExcecaoResponse|\StructType\CriarConfiguracoesExcecaoXMLResponse|\StructType\CriarConfiguracoesInterativoResponse|\StructType\CriarConfiguracoesMultiplosSensoresResponse|\StructType\CriarConfiguracoesOpcoesSegurancaResponse|\StructType\CriarConfiguracoesOpcoesSeResponse|\StructType\CriarConfiguracoesSenhasResponse|\StructType\CriarConfiguracoesTemperaturaResponse|\StructType\CriarConfiguracoesTransicaoResponse|\StructType\CriarConfiguracoesUmidadeResponse|\StructType\CriarFuncaoProgramadaResponse|\StructType\CriarGrupoFuncaoProgramavelResponse|\StructType\CriarModTransicaoResponse|\StructType\CriarPerfilAlvoResponse|\StructType\CriarPerfilCercaResponse|\StructType\CriarPerfilRotaResponse|\StructType\CriarRegraResponse|\StructType\CriarSolicitacaoEspelhamentoReversoResponse|\StructType\CriarTesteComunicacaoResponse|\StructType\CriarVeiculoSensorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
