<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoverCfgTransmissao StructType
 * Meta information extracted from the WSDL
 * - type: tns:RemoverCfgTransmissao
 * @subpackage Structs
 */
class RemoverCfgTransmissao extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdTerminal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdTerminal;
    /**
     * The IdSequencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdSequencia;
    /**
     * The IdConfig
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdConfig;
    /**
     * The FlagCentralRastSeg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FlagCentralRastSeg;
    /**
     * The Tecnologia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tecnologia;
    /**
     * Constructor method for RemoverCfgTransmissao
     * @uses RemoverCfgTransmissao::setUsuario()
     * @uses RemoverCfgTransmissao::setSenha()
     * @uses RemoverCfgTransmissao::setIdTerminal()
     * @uses RemoverCfgTransmissao::setIdSequencia()
     * @uses RemoverCfgTransmissao::setIdConfig()
     * @uses RemoverCfgTransmissao::setFlagCentralRastSeg()
     * @uses RemoverCfgTransmissao::setTecnologia()
     * @param string $usuario
     * @param string $senha
     * @param int $idTerminal
     * @param int $idSequencia
     * @param int $idConfig
     * @param string $flagCentralRastSeg
     * @param int $tecnologia
     */
    public function __construct($usuario = null, $senha = null, $idTerminal = null, $idSequencia = null, $idConfig = null, $flagCentralRastSeg = null, $tecnologia = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdTerminal($idTerminal)
            ->setIdSequencia($idSequencia)
            ->setIdConfig($idConfig)
            ->setFlagCentralRastSeg($flagCentralRastSeg)
            ->setTecnologia($tecnologia);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\RemoverCfgTransmissao
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\RemoverCfgTransmissao
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdTerminal value
     * @return int|null
     */
    public function getIdTerminal()
    {
        return $this->IdTerminal;
    }
    /**
     * Set IdTerminal value
     * @param int $idTerminal
     * @return \StructType\RemoverCfgTransmissao
     */
    public function setIdTerminal($idTerminal = null)
    {
        // validation for constraint: int
        if (!is_null($idTerminal) && !(is_int($idTerminal) || ctype_digit($idTerminal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idTerminal, true), gettype($idTerminal)), __LINE__);
        }
        $this->IdTerminal = $idTerminal;
        return $this;
    }
    /**
     * Get IdSequencia value
     * @return int|null
     */
    public function getIdSequencia()
    {
        return $this->IdSequencia;
    }
    /**
     * Set IdSequencia value
     * @param int $idSequencia
     * @return \StructType\RemoverCfgTransmissao
     */
    public function setIdSequencia($idSequencia = null)
    {
        // validation for constraint: int
        if (!is_null($idSequencia) && !(is_int($idSequencia) || ctype_digit($idSequencia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idSequencia, true), gettype($idSequencia)), __LINE__);
        }
        $this->IdSequencia = $idSequencia;
        return $this;
    }
    /**
     * Get IdConfig value
     * @return int|null
     */
    public function getIdConfig()
    {
        return $this->IdConfig;
    }
    /**
     * Set IdConfig value
     * @param int $idConfig
     * @return \StructType\RemoverCfgTransmissao
     */
    public function setIdConfig($idConfig = null)
    {
        // validation for constraint: int
        if (!is_null($idConfig) && !(is_int($idConfig) || ctype_digit($idConfig))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idConfig, true), gettype($idConfig)), __LINE__);
        }
        $this->IdConfig = $idConfig;
        return $this;
    }
    /**
     * Get FlagCentralRastSeg value
     * @return string|null
     */
    public function getFlagCentralRastSeg()
    {
        return $this->FlagCentralRastSeg;
    }
    /**
     * Set FlagCentralRastSeg value
     * @param string $flagCentralRastSeg
     * @return \StructType\RemoverCfgTransmissao
     */
    public function setFlagCentralRastSeg($flagCentralRastSeg = null)
    {
        // validation for constraint: string
        if (!is_null($flagCentralRastSeg) && !is_string($flagCentralRastSeg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flagCentralRastSeg, true), gettype($flagCentralRastSeg)), __LINE__);
        }
        $this->FlagCentralRastSeg = $flagCentralRastSeg;
        return $this;
    }
    /**
     * Get Tecnologia value
     * @return int|null
     */
    public function getTecnologia()
    {
        return $this->Tecnologia;
    }
    /**
     * Set Tecnologia value
     * @param int $tecnologia
     * @return \StructType\RemoverCfgTransmissao
     */
    public function setTecnologia($tecnologia = null)
    {
        // validation for constraint: int
        if (!is_null($tecnologia) && !(is_int($tecnologia) || ctype_digit($tecnologia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tecnologia, true), gettype($tecnologia)), __LINE__);
        }
        $this->Tecnologia = $tecnologia;
        return $this;
    }
}
