<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MudarGrupoDoAlvo StructType
 * Meta information extracted from the WSDL
 * - type: tns:MudarGrupoDoAlvo
 * @subpackage Structs
 */
class MudarGrupoDoAlvo extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The GrupoAntigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GrupoAntigo;
    /**
     * The NomeDoAlvo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NomeDoAlvo;
    /**
     * The GrupoNovo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GrupoNovo;
    /**
     * Constructor method for MudarGrupoDoAlvo
     * @uses MudarGrupoDoAlvo::setUsuario()
     * @uses MudarGrupoDoAlvo::setSenha()
     * @uses MudarGrupoDoAlvo::setGrupoAntigo()
     * @uses MudarGrupoDoAlvo::setNomeDoAlvo()
     * @uses MudarGrupoDoAlvo::setGrupoNovo()
     * @param string $usuario
     * @param string $senha
     * @param string $grupoAntigo
     * @param string $nomeDoAlvo
     * @param string $grupoNovo
     */
    public function __construct($usuario = null, $senha = null, $grupoAntigo = null, $nomeDoAlvo = null, $grupoNovo = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setGrupoAntigo($grupoAntigo)
            ->setNomeDoAlvo($nomeDoAlvo)
            ->setGrupoNovo($grupoNovo);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\MudarGrupoDoAlvo
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\MudarGrupoDoAlvo
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get GrupoAntigo value
     * @return string|null
     */
    public function getGrupoAntigo()
    {
        return $this->GrupoAntigo;
    }
    /**
     * Set GrupoAntigo value
     * @param string $grupoAntigo
     * @return \StructType\MudarGrupoDoAlvo
     */
    public function setGrupoAntigo($grupoAntigo = null)
    {
        // validation for constraint: string
        if (!is_null($grupoAntigo) && !is_string($grupoAntigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grupoAntigo, true), gettype($grupoAntigo)), __LINE__);
        }
        $this->GrupoAntigo = $grupoAntigo;
        return $this;
    }
    /**
     * Get NomeDoAlvo value
     * @return string|null
     */
    public function getNomeDoAlvo()
    {
        return $this->NomeDoAlvo;
    }
    /**
     * Set NomeDoAlvo value
     * @param string $nomeDoAlvo
     * @return \StructType\MudarGrupoDoAlvo
     */
    public function setNomeDoAlvo($nomeDoAlvo = null)
    {
        // validation for constraint: string
        if (!is_null($nomeDoAlvo) && !is_string($nomeDoAlvo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeDoAlvo, true), gettype($nomeDoAlvo)), __LINE__);
        }
        $this->NomeDoAlvo = $nomeDoAlvo;
        return $this;
    }
    /**
     * Get GrupoNovo value
     * @return string|null
     */
    public function getGrupoNovo()
    {
        return $this->GrupoNovo;
    }
    /**
     * Set GrupoNovo value
     * @param string $grupoNovo
     * @return \StructType\MudarGrupoDoAlvo
     */
    public function setGrupoNovo($grupoNovo = null)
    {
        // validation for constraint: string
        if (!is_null($grupoNovo) && !is_string($grupoNovo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grupoNovo, true), gettype($grupoNovo)), __LINE__);
        }
        $this->GrupoNovo = $grupoNovo;
        return $this;
    }
}
