<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcluirTextoTerminal StructType
 * Meta information extracted from the WSDL
 * - type: tns:ExcluirTextoTerminal
 * @subpackage Structs
 */
class ExcluirTextoTerminal extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The Sequencial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Sequencial;
    /**
     * Constructor method for ExcluirTextoTerminal
     * @uses ExcluirTextoTerminal::setUsuario()
     * @uses ExcluirTextoTerminal::setSenha()
     * @uses ExcluirTextoTerminal::setSequencial()
     * @param string $usuario
     * @param string $senha
     * @param int $sequencial
     */
    public function __construct($usuario = null, $senha = null, $sequencial = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setSequencial($sequencial);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ExcluirTextoTerminal
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ExcluirTextoTerminal
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get Sequencial value
     * @return int|null
     */
    public function getSequencial()
    {
        return $this->Sequencial;
    }
    /**
     * Set Sequencial value
     * @param int $sequencial
     * @return \StructType\ExcluirTextoTerminal
     */
    public function setSequencial($sequencial = null)
    {
        // validation for constraint: int
        if (!is_null($sequencial) && !(is_int($sequencial) || ctype_digit($sequencial))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequencial, true), gettype($sequencial)), __LINE__);
        }
        $this->Sequencial = $sequencial;
        return $this;
    }
}
