<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcluirGrupoRota StructType
 * Meta information extracted from the WSDL
 * - type: tns:ExcluirGrupoRota
 * @subpackage Structs
 */
class ExcluirGrupoRota extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The idGrupoRota
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idGrupoRota;
    /**
     * Constructor method for ExcluirGrupoRota
     * @uses ExcluirGrupoRota::setUsuario()
     * @uses ExcluirGrupoRota::setSenha()
     * @uses ExcluirGrupoRota::setIdGrupoRota()
     * @param string $usuario
     * @param string $senha
     * @param int $idGrupoRota
     */
    public function __construct($usuario = null, $senha = null, $idGrupoRota = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdGrupoRota($idGrupoRota);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ExcluirGrupoRota
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ExcluirGrupoRota
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get idGrupoRota value
     * @return int|null
     */
    public function getIdGrupoRota()
    {
        return $this->idGrupoRota;
    }
    /**
     * Set idGrupoRota value
     * @param int $idGrupoRota
     * @return \StructType\ExcluirGrupoRota
     */
    public function setIdGrupoRota($idGrupoRota = null)
    {
        // validation for constraint: int
        if (!is_null($idGrupoRota) && !(is_int($idGrupoRota) || ctype_digit($idGrupoRota))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idGrupoRota, true), gettype($idGrupoRota)), __LINE__);
        }
        $this->idGrupoRota = $idGrupoRota;
        return $this;
    }
}
