<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditarSensorDeAlarme StructType
 * Meta information extracted from the WSDL
 * - type: tns:EditarSensorDeAlarme
 * @subpackage Structs
 */
class EditarSensorDeAlarme extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdSaver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdSaver;
    /**
     * The Tipo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tipo;
    /**
     * The Descricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Descricao;
    /**
     * Constructor method for EditarSensorDeAlarme
     * @uses EditarSensorDeAlarme::setUsuario()
     * @uses EditarSensorDeAlarme::setSenha()
     * @uses EditarSensorDeAlarme::setIdSaver()
     * @uses EditarSensorDeAlarme::setTipo()
     * @uses EditarSensorDeAlarme::setDescricao()
     * @param string $usuario
     * @param string $senha
     * @param int $idSaver
     * @param int $tipo
     * @param string $descricao
     */
    public function __construct($usuario = null, $senha = null, $idSaver = null, $tipo = null, $descricao = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdSaver($idSaver)
            ->setTipo($tipo)
            ->setDescricao($descricao);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\EditarSensorDeAlarme
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\EditarSensorDeAlarme
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdSaver value
     * @return int|null
     */
    public function getIdSaver()
    {
        return $this->IdSaver;
    }
    /**
     * Set IdSaver value
     * @param int $idSaver
     * @return \StructType\EditarSensorDeAlarme
     */
    public function setIdSaver($idSaver = null)
    {
        // validation for constraint: int
        if (!is_null($idSaver) && !(is_int($idSaver) || ctype_digit($idSaver))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idSaver, true), gettype($idSaver)), __LINE__);
        }
        $this->IdSaver = $idSaver;
        return $this;
    }
    /**
     * Get Tipo value
     * @return int|null
     */
    public function getTipo()
    {
        return $this->Tipo;
    }
    /**
     * Set Tipo value
     * @param int $tipo
     * @return \StructType\EditarSensorDeAlarme
     */
    public function setTipo($tipo = null)
    {
        // validation for constraint: int
        if (!is_null($tipo) && !(is_int($tipo) || ctype_digit($tipo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipo, true), gettype($tipo)), __LINE__);
        }
        $this->Tipo = $tipo;
        return $this;
    }
    /**
     * Get Descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->Descricao;
    }
    /**
     * Set Descricao value
     * @param string $descricao
     * @return \StructType\EditarSensorDeAlarme
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->Descricao = $descricao;
        return $this;
    }
}
