<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CriarConfiguracoesExcecaoXML StructType
 * Meta information extracted from the WSDL
 * - type: tns:CriarConfiguracoesExcecaoXML
 * @subpackage Structs
 */
class CriarConfiguracoesExcecaoXML extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The XML
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $XML;
    /**
     * The DESABILITAR_GRPS
     * @var int
     */
    public $DESABILITAR_GRPS;
    /**
     * The Nome_Perfil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Nome_Perfil;
    /**
     * The IdTransOperacao
     * @var int
     */
    public $IdTransOperacao;
    /**
     * The IdConfiguracao
     * @var int
     */
    public $IdConfiguracao;
    /**
     * Constructor method for CriarConfiguracoesExcecaoXML
     * @uses CriarConfiguracoesExcecaoXML::setUsuario()
     * @uses CriarConfiguracoesExcecaoXML::setSenha()
     * @uses CriarConfiguracoesExcecaoXML::setXML()
     * @uses CriarConfiguracoesExcecaoXML::setDESABILITAR_GRPS()
     * @uses CriarConfiguracoesExcecaoXML::setNome_Perfil()
     * @uses CriarConfiguracoesExcecaoXML::setIdTransOperacao()
     * @uses CriarConfiguracoesExcecaoXML::setIdConfiguracao()
     * @param string $usuario
     * @param string $senha
     * @param string $xML
     * @param int $dESABILITAR_GRPS
     * @param string $nome_Perfil
     * @param int $idTransOperacao
     * @param int $idConfiguracao
     */
    public function __construct($usuario = null, $senha = null, $xML = null, $dESABILITAR_GRPS = null, $nome_Perfil = null, $idTransOperacao = null, $idConfiguracao = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setXML($xML)
            ->setDESABILITAR_GRPS($dESABILITAR_GRPS)
            ->setNome_Perfil($nome_Perfil)
            ->setIdTransOperacao($idTransOperacao)
            ->setIdConfiguracao($idConfiguracao);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\CriarConfiguracoesExcecaoXML
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\CriarConfiguracoesExcecaoXML
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get XML value
     * @return string|null
     */
    public function getXML()
    {
        return $this->XML;
    }
    /**
     * Set XML value
     * @param string $xML
     * @return \StructType\CriarConfiguracoesExcecaoXML
     */
    public function setXML($xML = null)
    {
        // validation for constraint: string
        if (!is_null($xML) && !is_string($xML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xML, true), gettype($xML)), __LINE__);
        }
        $this->XML = $xML;
        return $this;
    }
    /**
     * Get DESABILITAR_GRPS value
     * @return int|null
     */
    public function getDESABILITAR_GRPS()
    {
        return $this->DESABILITAR_GRPS;
    }
    /**
     * Set DESABILITAR_GRPS value
     * @param int $dESABILITAR_GRPS
     * @return \StructType\CriarConfiguracoesExcecaoXML
     */
    public function setDESABILITAR_GRPS($dESABILITAR_GRPS = null)
    {
        // validation for constraint: int
        if (!is_null($dESABILITAR_GRPS) && !(is_int($dESABILITAR_GRPS) || ctype_digit($dESABILITAR_GRPS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dESABILITAR_GRPS, true), gettype($dESABILITAR_GRPS)), __LINE__);
        }
        $this->DESABILITAR_GRPS = $dESABILITAR_GRPS;
        return $this;
    }
    /**
     * Get Nome_Perfil value
     * @return string|null
     */
    public function getNome_Perfil()
    {
        return $this->Nome_Perfil;
    }
    /**
     * Set Nome_Perfil value
     * @param string $nome_Perfil
     * @return \StructType\CriarConfiguracoesExcecaoXML
     */
    public function setNome_Perfil($nome_Perfil = null)
    {
        // validation for constraint: string
        if (!is_null($nome_Perfil) && !is_string($nome_Perfil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome_Perfil, true), gettype($nome_Perfil)), __LINE__);
        }
        $this->Nome_Perfil = $nome_Perfil;
        return $this;
    }
    /**
     * Get IdTransOperacao value
     * @return int|null
     */
    public function getIdTransOperacao()
    {
        return $this->IdTransOperacao;
    }
    /**
     * Set IdTransOperacao value
     * @param int $idTransOperacao
     * @return \StructType\CriarConfiguracoesExcecaoXML
     */
    public function setIdTransOperacao($idTransOperacao = null)
    {
        // validation for constraint: int
        if (!is_null($idTransOperacao) && !(is_int($idTransOperacao) || ctype_digit($idTransOperacao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idTransOperacao, true), gettype($idTransOperacao)), __LINE__);
        }
        $this->IdTransOperacao = $idTransOperacao;
        return $this;
    }
    /**
     * Get IdConfiguracao value
     * @return int|null
     */
    public function getIdConfiguracao()
    {
        return $this->IdConfiguracao;
    }
    /**
     * Set IdConfiguracao value
     * @param int $idConfiguracao
     * @return \StructType\CriarConfiguracoesExcecaoXML
     */
    public function setIdConfiguracao($idConfiguracao = null)
    {
        // validation for constraint: int
        if (!is_null($idConfiguracao) && !(is_int($idConfiguracao) || ctype_digit($idConfiguracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idConfiguracao, true), gettype($idConfiguracao)), __LINE__);
        }
        $this->IdConfiguracao = $idConfiguracao;
        return $this;
    }
}
