<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cadastrar ServiceType
 * @subpackage Services
 */
class Cadastrar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CadastrarPerfilConfiguracao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CadastrarPerfilConfiguracao $parameters
     * @return \StructType\CadastrarPerfilConfiguracaoResponse|bool
     */
    public function CadastrarPerfilConfiguracao(\StructType\CadastrarPerfilConfiguracao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CadastrarPerfilConfiguracao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CadastrarOperacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CadastrarOperacao $parameters
     * @return \StructType\CadastrarOperacaoResponse|bool
     */
    public function CadastrarOperacao(\StructType\CadastrarOperacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CadastrarOperacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CadastrarItensOperacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CadastrarItensOperacao $parameters
     * @return \StructType\CadastrarItensOperacaoResponse|bool
     */
    public function CadastrarItensOperacao(\StructType\CadastrarItensOperacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CadastrarItensOperacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CadastrarTextoTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CadastrarTextoTerminal $parameters
     * @return \StructType\CadastrarTextoTerminalResponse|bool
     */
    public function CadastrarTextoTerminal(\StructType\CadastrarTextoTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CadastrarTextoTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CadastrarClasseDeReferencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CadastrarClasseDeReferencia $parameters
     * @return \StructType\CadastrarClasseDeReferenciaResponse|bool
     */
    public function CadastrarClasseDeReferencia(\StructType\CadastrarClasseDeReferencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CadastrarClasseDeReferencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CadastrarPontoDeReferencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CadastrarPontoDeReferencia $parameters
     * @return \StructType\CadastrarPontoDeReferenciaResponse|bool
     */
    public function CadastrarPontoDeReferencia(\StructType\CadastrarPontoDeReferencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CadastrarPontoDeReferencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CadastrarMotivo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CadastrarMotivo $parameters
     * @return \StructType\CadastrarMotivoResponse|bool
     */
    public function CadastrarMotivo(\StructType\CadastrarMotivo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CadastrarMotivo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CadastrarSensorDeAlarme
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CadastrarSensorDeAlarme $parameters
     * @return \StructType\CadastrarSensorDeAlarmeResponse|bool
     */
    public function CadastrarSensorDeAlarme(\StructType\CadastrarSensorDeAlarme $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CadastrarSensorDeAlarme($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CadastrarSensorDeAlarmeDefault
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CadastrarSensorDeAlarmeDefault $parameters
     * @return \StructType\CadastrarSensorDeAlarmeDefaultResponse|bool
     */
    public function CadastrarSensorDeAlarmeDefault(\StructType\CadastrarSensorDeAlarmeDefault $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CadastrarSensorDeAlarmeDefault($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CadastrarClasseDeReferenciaResponse|\StructType\CadastrarItensOperacaoResponse|\StructType\CadastrarMotivoResponse|\StructType\CadastrarOperacaoResponse|\StructType\CadastrarPerfilConfiguracaoResponse|\StructType\CadastrarPontoDeReferenciaResponse|\StructType\CadastrarSensorDeAlarmeDefaultResponse|\StructType\CadastrarSensorDeAlarmeResponse|\StructType\CadastrarTextoTerminalResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
