<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ativar ServiceType
 * @subpackage Services
 */
class Ativar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AtivarModoRastreado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtivarModoRastreado $parameters
     * @return \StructType\AtivarModoRastreadoResponse|bool
     */
    public function AtivarModoRastreado(\StructType\AtivarModoRastreado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AtivarModoRastreado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtivarModoInterativo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtivarModoInterativo $parameters
     * @return \StructType\AtivarModoInterativoResponse|bool
     */
    public function AtivarModoInterativo(\StructType\AtivarModoInterativo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AtivarModoInterativo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AtivarModoInterativoResponse|\StructType\AtivarModoRastreadoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
