<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransmitirParametrosVeiculo StructType
 * Meta information extracted from the WSDL
 * - type: tns:TransmitirParametrosVeiculo
 * @subpackage Structs
 */
class TransmitirParametrosVeiculo extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The idVeiculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idVeiculo;
    /**
     * The Secao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Secao;
    /**
     * Constructor method for TransmitirParametrosVeiculo
     * @uses TransmitirParametrosVeiculo::setUsuario()
     * @uses TransmitirParametrosVeiculo::setSenha()
     * @uses TransmitirParametrosVeiculo::setIdVeiculo()
     * @uses TransmitirParametrosVeiculo::setSecao()
     * @param string $usuario
     * @param string $senha
     * @param int $idVeiculo
     * @param int $secao
     */
    public function __construct($usuario = null, $senha = null, $idVeiculo = null, $secao = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdVeiculo($idVeiculo)
            ->setSecao($secao);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\TransmitirParametrosVeiculo
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\TransmitirParametrosVeiculo
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get idVeiculo value
     * @return int|null
     */
    public function getIdVeiculo()
    {
        return $this->idVeiculo;
    }
    /**
     * Set idVeiculo value
     * @param int $idVeiculo
     * @return \StructType\TransmitirParametrosVeiculo
     */
    public function setIdVeiculo($idVeiculo = null)
    {
        // validation for constraint: int
        if (!is_null($idVeiculo) && !(is_int($idVeiculo) || ctype_digit($idVeiculo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idVeiculo, true), gettype($idVeiculo)), __LINE__);
        }
        $this->idVeiculo = $idVeiculo;
        return $this;
    }
    /**
     * Get Secao value
     * @return int|null
     */
    public function getSecao()
    {
        return $this->Secao;
    }
    /**
     * Set Secao value
     * @param int $secao
     * @return \StructType\TransmitirParametrosVeiculo
     */
    public function setSecao($secao = null)
    {
        // validation for constraint: int
        if (!is_null($secao) && !(is_int($secao) || ctype_digit($secao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($secao, true), gettype($secao)), __LINE__);
        }
        $this->Secao = $secao;
        return $this;
    }
}
