<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransmitirAlvo StructType
 * Meta information extracted from the WSDL
 * - type: tns:TransmitirAlvo
 * @subpackage Structs
 */
class TransmitirAlvo extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The idVeiculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idVeiculo;
    /**
     * The tipoAlvos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $tipoAlvos;
    /**
     * The persistencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $persistencia;
    /**
     * The EmSobreposicao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EmSobreposicao;
    /**
     * Constructor method for TransmitirAlvo
     * @uses TransmitirAlvo::setUsuario()
     * @uses TransmitirAlvo::setSenha()
     * @uses TransmitirAlvo::setIdVeiculo()
     * @uses TransmitirAlvo::setTipoAlvos()
     * @uses TransmitirAlvo::setPersistencia()
     * @uses TransmitirAlvo::setEmSobreposicao()
     * @param string $usuario
     * @param string $senha
     * @param int $idVeiculo
     * @param int $tipoAlvos
     * @param int $persistencia
     * @param int $emSobreposicao
     */
    public function __construct($usuario = null, $senha = null, $idVeiculo = null, $tipoAlvos = null, $persistencia = null, $emSobreposicao = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdVeiculo($idVeiculo)
            ->setTipoAlvos($tipoAlvos)
            ->setPersistencia($persistencia)
            ->setEmSobreposicao($emSobreposicao);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\TransmitirAlvo
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\TransmitirAlvo
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get idVeiculo value
     * @return int|null
     */
    public function getIdVeiculo()
    {
        return $this->idVeiculo;
    }
    /**
     * Set idVeiculo value
     * @param int $idVeiculo
     * @return \StructType\TransmitirAlvo
     */
    public function setIdVeiculo($idVeiculo = null)
    {
        // validation for constraint: int
        if (!is_null($idVeiculo) && !(is_int($idVeiculo) || ctype_digit($idVeiculo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idVeiculo, true), gettype($idVeiculo)), __LINE__);
        }
        $this->idVeiculo = $idVeiculo;
        return $this;
    }
    /**
     * Get tipoAlvos value
     * @return int|null
     */
    public function getTipoAlvos()
    {
        return $this->tipoAlvos;
    }
    /**
     * Set tipoAlvos value
     * @param int $tipoAlvos
     * @return \StructType\TransmitirAlvo
     */
    public function setTipoAlvos($tipoAlvos = null)
    {
        // validation for constraint: int
        if (!is_null($tipoAlvos) && !(is_int($tipoAlvos) || ctype_digit($tipoAlvos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipoAlvos, true), gettype($tipoAlvos)), __LINE__);
        }
        $this->tipoAlvos = $tipoAlvos;
        return $this;
    }
    /**
     * Get persistencia value
     * @return int|null
     */
    public function getPersistencia()
    {
        return $this->persistencia;
    }
    /**
     * Set persistencia value
     * @param int $persistencia
     * @return \StructType\TransmitirAlvo
     */
    public function setPersistencia($persistencia = null)
    {
        // validation for constraint: int
        if (!is_null($persistencia) && !(is_int($persistencia) || ctype_digit($persistencia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($persistencia, true), gettype($persistencia)), __LINE__);
        }
        $this->persistencia = $persistencia;
        return $this;
    }
    /**
     * Get EmSobreposicao value
     * @return int|null
     */
    public function getEmSobreposicao()
    {
        return $this->EmSobreposicao;
    }
    /**
     * Set EmSobreposicao value
     * @param int $emSobreposicao
     * @return \StructType\TransmitirAlvo
     */
    public function setEmSobreposicao($emSobreposicao = null)
    {
        // validation for constraint: int
        if (!is_null($emSobreposicao) && !(is_int($emSobreposicao) || ctype_digit($emSobreposicao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($emSobreposicao, true), gettype($emSobreposicao)), __LINE__);
        }
        $this->EmSobreposicao = $emSobreposicao;
        return $this;
    }
}
