<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Operacao_Associar StructType
 * Meta information extracted from the WSDL
 * - type: tns:Operacao_Associar
 * @subpackage Structs
 */
class Operacao_Associar extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdTerminal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdTerminal;
    /**
     * The IdOperacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdOperacao;
    /**
     * Constructor method for Operacao_Associar
     * @uses Operacao_Associar::setUsuario()
     * @uses Operacao_Associar::setSenha()
     * @uses Operacao_Associar::setIdTerminal()
     * @uses Operacao_Associar::setIdOperacao()
     * @param string $usuario
     * @param string $senha
     * @param int $idTerminal
     * @param int $idOperacao
     */
    public function __construct($usuario = null, $senha = null, $idTerminal = null, $idOperacao = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdTerminal($idTerminal)
            ->setIdOperacao($idOperacao);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\Operacao_Associar
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\Operacao_Associar
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdTerminal value
     * @return int|null
     */
    public function getIdTerminal()
    {
        return $this->IdTerminal;
    }
    /**
     * Set IdTerminal value
     * @param int $idTerminal
     * @return \StructType\Operacao_Associar
     */
    public function setIdTerminal($idTerminal = null)
    {
        // validation for constraint: int
        if (!is_null($idTerminal) && !(is_int($idTerminal) || ctype_digit($idTerminal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idTerminal, true), gettype($idTerminal)), __LINE__);
        }
        $this->IdTerminal = $idTerminal;
        return $this;
    }
    /**
     * Get IdOperacao value
     * @return int|null
     */
    public function getIdOperacao()
    {
        return $this->IdOperacao;
    }
    /**
     * Set IdOperacao value
     * @param int $idOperacao
     * @return \StructType\Operacao_Associar
     */
    public function setIdOperacao($idOperacao = null)
    {
        // validation for constraint: int
        if (!is_null($idOperacao) && !(is_int($idOperacao) || ctype_digit($idOperacao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idOperacao, true), gettype($idOperacao)), __LINE__);
        }
        $this->IdOperacao = $idOperacao;
        return $this;
    }
}
