<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObtemEventosOmnifrota StructType
 * Meta information extracted from the WSDL
 * - type: tns:ObtemEventosOmnifrota
 * @subpackage Structs
 */
class ObtemEventosOmnifrota extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The UltimoSequencial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UltimoSequencial;
    /**
     * Constructor method for ObtemEventosOmnifrota
     * @uses ObtemEventosOmnifrota::setUsuario()
     * @uses ObtemEventosOmnifrota::setSenha()
     * @uses ObtemEventosOmnifrota::setUltimoSequencial()
     * @param string $usuario
     * @param string $senha
     * @param int $ultimoSequencial
     */
    public function __construct($usuario = null, $senha = null, $ultimoSequencial = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setUltimoSequencial($ultimoSequencial);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ObtemEventosOmnifrota
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ObtemEventosOmnifrota
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get UltimoSequencial value
     * @return int|null
     */
    public function getUltimoSequencial()
    {
        return $this->UltimoSequencial;
    }
    /**
     * Set UltimoSequencial value
     * @param int $ultimoSequencial
     * @return \StructType\ObtemEventosOmnifrota
     */
    public function setUltimoSequencial($ultimoSequencial = null)
    {
        // validation for constraint: int
        if (!is_null($ultimoSequencial) && !(is_int($ultimoSequencial) || ctype_digit($ultimoSequencial))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ultimoSequencial, true), gettype($ultimoSequencial)), __LINE__);
        }
        $this->UltimoSequencial = $ultimoSequencial;
        return $this;
    }
}
