<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObtemEventosMF StructType
 * Meta information extracted from the WSDL
 * - type: tns:ObtemEventosMF
 * @subpackage Structs
 */
class ObtemEventosMF extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The UltimoSequencialCtrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UltimoSequencialCtrl;
    /**
     * Constructor method for ObtemEventosMF
     * @uses ObtemEventosMF::setUsuario()
     * @uses ObtemEventosMF::setSenha()
     * @uses ObtemEventosMF::setUltimoSequencialCtrl()
     * @param string $usuario
     * @param string $senha
     * @param int $ultimoSequencialCtrl
     */
    public function __construct($usuario = null, $senha = null, $ultimoSequencialCtrl = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setUltimoSequencialCtrl($ultimoSequencialCtrl);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ObtemEventosMF
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ObtemEventosMF
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get UltimoSequencialCtrl value
     * @return int|null
     */
    public function getUltimoSequencialCtrl()
    {
        return $this->UltimoSequencialCtrl;
    }
    /**
     * Set UltimoSequencialCtrl value
     * @param int $ultimoSequencialCtrl
     * @return \StructType\ObtemEventosMF
     */
    public function setUltimoSequencialCtrl($ultimoSequencialCtrl = null)
    {
        // validation for constraint: int
        if (!is_null($ultimoSequencialCtrl) && !(is_int($ultimoSequencialCtrl) || ctype_digit($ultimoSequencialCtrl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ultimoSequencialCtrl, true), gettype($ultimoSequencialCtrl)), __LINE__);
        }
        $this->UltimoSequencialCtrl = $ultimoSequencialCtrl;
        return $this;
    }
}
