<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObtemEventos StructType
 * Meta information extracted from the WSDL
 * - type: tns:ObtemEventos
 * @subpackage Structs
 */
class ObtemEventos extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The UltimoSequencial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UltimoSequencial;
    /**
     * The UltimoSequencialCtrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UltimoSequencialCtrl;
    /**
     * The UltimoSeqCtrlImport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UltimoSeqCtrlImport;
    /**
     * Constructor method for ObtemEventos
     * @uses ObtemEventos::setUsuario()
     * @uses ObtemEventos::setSenha()
     * @uses ObtemEventos::setUltimoSequencial()
     * @uses ObtemEventos::setUltimoSequencialCtrl()
     * @uses ObtemEventos::setUltimoSeqCtrlImport()
     * @param string $usuario
     * @param string $senha
     * @param int $ultimoSequencial
     * @param int $ultimoSequencialCtrl
     * @param int $ultimoSeqCtrlImport
     */
    public function __construct($usuario = null, $senha = null, $ultimoSequencial = null, $ultimoSequencialCtrl = null, $ultimoSeqCtrlImport = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setUltimoSequencial($ultimoSequencial)
            ->setUltimoSequencialCtrl($ultimoSequencialCtrl)
            ->setUltimoSeqCtrlImport($ultimoSeqCtrlImport);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ObtemEventos
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ObtemEventos
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get UltimoSequencial value
     * @return int|null
     */
    public function getUltimoSequencial()
    {
        return $this->UltimoSequencial;
    }
    /**
     * Set UltimoSequencial value
     * @param int $ultimoSequencial
     * @return \StructType\ObtemEventos
     */
    public function setUltimoSequencial($ultimoSequencial = null)
    {
        // validation for constraint: int
        if (!is_null($ultimoSequencial) && !(is_int($ultimoSequencial) || ctype_digit($ultimoSequencial))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ultimoSequencial, true), gettype($ultimoSequencial)), __LINE__);
        }
        $this->UltimoSequencial = $ultimoSequencial;
        return $this;
    }
    /**
     * Get UltimoSequencialCtrl value
     * @return int|null
     */
    public function getUltimoSequencialCtrl()
    {
        return $this->UltimoSequencialCtrl;
    }
    /**
     * Set UltimoSequencialCtrl value
     * @param int $ultimoSequencialCtrl
     * @return \StructType\ObtemEventos
     */
    public function setUltimoSequencialCtrl($ultimoSequencialCtrl = null)
    {
        // validation for constraint: int
        if (!is_null($ultimoSequencialCtrl) && !(is_int($ultimoSequencialCtrl) || ctype_digit($ultimoSequencialCtrl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ultimoSequencialCtrl, true), gettype($ultimoSequencialCtrl)), __LINE__);
        }
        $this->UltimoSequencialCtrl = $ultimoSequencialCtrl;
        return $this;
    }
    /**
     * Get UltimoSeqCtrlImport value
     * @return int|null
     */
    public function getUltimoSeqCtrlImport()
    {
        return $this->UltimoSeqCtrlImport;
    }
    /**
     * Set UltimoSeqCtrlImport value
     * @param int $ultimoSeqCtrlImport
     * @return \StructType\ObtemEventos
     */
    public function setUltimoSeqCtrlImport($ultimoSeqCtrlImport = null)
    {
        // validation for constraint: int
        if (!is_null($ultimoSeqCtrlImport) && !(is_int($ultimoSeqCtrlImport) || ctype_digit($ultimoSeqCtrlImport))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ultimoSeqCtrlImport, true), gettype($ultimoSeqCtrlImport)), __LINE__);
        }
        $this->UltimoSeqCtrlImport = $ultimoSeqCtrlImport;
        return $this;
    }
}
