<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MudarGrupoDaCerca StructType
 * Meta information extracted from the WSDL
 * - type: tns:MudarGrupoDaCerca
 * @subpackage Structs
 */
class MudarGrupoDaCerca extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The GrupoAntigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GrupoAntigo;
    /**
     * The NomeDaCerca
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NomeDaCerca;
    /**
     * The GrupoNovo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GrupoNovo;
    /**
     * Constructor method for MudarGrupoDaCerca
     * @uses MudarGrupoDaCerca::setUsuario()
     * @uses MudarGrupoDaCerca::setSenha()
     * @uses MudarGrupoDaCerca::setGrupoAntigo()
     * @uses MudarGrupoDaCerca::setNomeDaCerca()
     * @uses MudarGrupoDaCerca::setGrupoNovo()
     * @param string $usuario
     * @param string $senha
     * @param string $grupoAntigo
     * @param string $nomeDaCerca
     * @param string $grupoNovo
     */
    public function __construct($usuario = null, $senha = null, $grupoAntigo = null, $nomeDaCerca = null, $grupoNovo = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setGrupoAntigo($grupoAntigo)
            ->setNomeDaCerca($nomeDaCerca)
            ->setGrupoNovo($grupoNovo);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\MudarGrupoDaCerca
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\MudarGrupoDaCerca
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get GrupoAntigo value
     * @return string|null
     */
    public function getGrupoAntigo()
    {
        return $this->GrupoAntigo;
    }
    /**
     * Set GrupoAntigo value
     * @param string $grupoAntigo
     * @return \StructType\MudarGrupoDaCerca
     */
    public function setGrupoAntigo($grupoAntigo = null)
    {
        // validation for constraint: string
        if (!is_null($grupoAntigo) && !is_string($grupoAntigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grupoAntigo, true), gettype($grupoAntigo)), __LINE__);
        }
        $this->GrupoAntigo = $grupoAntigo;
        return $this;
    }
    /**
     * Get NomeDaCerca value
     * @return string|null
     */
    public function getNomeDaCerca()
    {
        return $this->NomeDaCerca;
    }
    /**
     * Set NomeDaCerca value
     * @param string $nomeDaCerca
     * @return \StructType\MudarGrupoDaCerca
     */
    public function setNomeDaCerca($nomeDaCerca = null)
    {
        // validation for constraint: string
        if (!is_null($nomeDaCerca) && !is_string($nomeDaCerca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeDaCerca, true), gettype($nomeDaCerca)), __LINE__);
        }
        $this->NomeDaCerca = $nomeDaCerca;
        return $this;
    }
    /**
     * Get GrupoNovo value
     * @return string|null
     */
    public function getGrupoNovo()
    {
        return $this->GrupoNovo;
    }
    /**
     * Set GrupoNovo value
     * @param string $grupoNovo
     * @return \StructType\MudarGrupoDaCerca
     */
    public function setGrupoNovo($grupoNovo = null)
    {
        // validation for constraint: string
        if (!is_null($grupoNovo) && !is_string($grupoNovo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grupoNovo, true), gettype($grupoNovo)), __LINE__);
        }
        $this->GrupoNovo = $grupoNovo;
        return $this;
    }
}
