<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeraSenhaAutorizacao StructType
 * Meta information extracted from the WSDL
 * - type: tns:GeraSenhaAutorizacao
 * @subpackage Structs
 */
class GeraSenhaAutorizacao extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdTerminal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdTerminal;
    /**
     * The Ocorrencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Ocorrencia;
    /**
     * The TipoOperacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TipoOperacao;
    /**
     * Constructor method for GeraSenhaAutorizacao
     * @uses GeraSenhaAutorizacao::setUsuario()
     * @uses GeraSenhaAutorizacao::setSenha()
     * @uses GeraSenhaAutorizacao::setIdTerminal()
     * @uses GeraSenhaAutorizacao::setOcorrencia()
     * @uses GeraSenhaAutorizacao::setTipoOperacao()
     * @param string $usuario
     * @param string $senha
     * @param int $idTerminal
     * @param string $ocorrencia
     * @param int $tipoOperacao
     */
    public function __construct($usuario = null, $senha = null, $idTerminal = null, $ocorrencia = null, $tipoOperacao = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdTerminal($idTerminal)
            ->setOcorrencia($ocorrencia)
            ->setTipoOperacao($tipoOperacao);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\GeraSenhaAutorizacao
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\GeraSenhaAutorizacao
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdTerminal value
     * @return int|null
     */
    public function getIdTerminal()
    {
        return $this->IdTerminal;
    }
    /**
     * Set IdTerminal value
     * @param int $idTerminal
     * @return \StructType\GeraSenhaAutorizacao
     */
    public function setIdTerminal($idTerminal = null)
    {
        // validation for constraint: int
        if (!is_null($idTerminal) && !(is_int($idTerminal) || ctype_digit($idTerminal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idTerminal, true), gettype($idTerminal)), __LINE__);
        }
        $this->IdTerminal = $idTerminal;
        return $this;
    }
    /**
     * Get Ocorrencia value
     * @return string|null
     */
    public function getOcorrencia()
    {
        return $this->Ocorrencia;
    }
    /**
     * Set Ocorrencia value
     * @param string $ocorrencia
     * @return \StructType\GeraSenhaAutorizacao
     */
    public function setOcorrencia($ocorrencia = null)
    {
        // validation for constraint: string
        if (!is_null($ocorrencia) && !is_string($ocorrencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ocorrencia, true), gettype($ocorrencia)), __LINE__);
        }
        $this->Ocorrencia = $ocorrencia;
        return $this;
    }
    /**
     * Get TipoOperacao value
     * @return int|null
     */
    public function getTipoOperacao()
    {
        return $this->TipoOperacao;
    }
    /**
     * Set TipoOperacao value
     * @param int $tipoOperacao
     * @return \StructType\GeraSenhaAutorizacao
     */
    public function setTipoOperacao($tipoOperacao = null)
    {
        // validation for constraint: int
        if (!is_null($tipoOperacao) && !(is_int($tipoOperacao) || ctype_digit($tipoOperacao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipoOperacao, true), gettype($tipoOperacao)), __LINE__);
        }
        $this->TipoOperacao = $tipoOperacao;
        return $this;
    }
}
