<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcluirOperacaoItem StructType
 * Meta information extracted from the WSDL
 * - type: tns:ExcluirOperacaoItem
 * @subpackage Structs
 */
class ExcluirOperacaoItem extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdOperacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdOperacao;
    /**
     * The IdConfiguracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdConfiguracao;
    /**
     * The IdOpcao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdOpcao;
    /**
     * Constructor method for ExcluirOperacaoItem
     * @uses ExcluirOperacaoItem::setUsuario()
     * @uses ExcluirOperacaoItem::setSenha()
     * @uses ExcluirOperacaoItem::setIdOperacao()
     * @uses ExcluirOperacaoItem::setIdConfiguracao()
     * @uses ExcluirOperacaoItem::setIdOpcao()
     * @param string $usuario
     * @param string $senha
     * @param int $idOperacao
     * @param int $idConfiguracao
     * @param int $idOpcao
     */
    public function __construct($usuario = null, $senha = null, $idOperacao = null, $idConfiguracao = null, $idOpcao = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdOperacao($idOperacao)
            ->setIdConfiguracao($idConfiguracao)
            ->setIdOpcao($idOpcao);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ExcluirOperacaoItem
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ExcluirOperacaoItem
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdOperacao value
     * @return int|null
     */
    public function getIdOperacao()
    {
        return $this->IdOperacao;
    }
    /**
     * Set IdOperacao value
     * @param int $idOperacao
     * @return \StructType\ExcluirOperacaoItem
     */
    public function setIdOperacao($idOperacao = null)
    {
        // validation for constraint: int
        if (!is_null($idOperacao) && !(is_int($idOperacao) || ctype_digit($idOperacao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idOperacao, true), gettype($idOperacao)), __LINE__);
        }
        $this->IdOperacao = $idOperacao;
        return $this;
    }
    /**
     * Get IdConfiguracao value
     * @return int|null
     */
    public function getIdConfiguracao()
    {
        return $this->IdConfiguracao;
    }
    /**
     * Set IdConfiguracao value
     * @param int $idConfiguracao
     * @return \StructType\ExcluirOperacaoItem
     */
    public function setIdConfiguracao($idConfiguracao = null)
    {
        // validation for constraint: int
        if (!is_null($idConfiguracao) && !(is_int($idConfiguracao) || ctype_digit($idConfiguracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idConfiguracao, true), gettype($idConfiguracao)), __LINE__);
        }
        $this->IdConfiguracao = $idConfiguracao;
        return $this;
    }
    /**
     * Get IdOpcao value
     * @return int|null
     */
    public function getIdOpcao()
    {
        return $this->IdOpcao;
    }
    /**
     * Set IdOpcao value
     * @param int $idOpcao
     * @return \StructType\ExcluirOperacaoItem
     */
    public function setIdOpcao($idOpcao = null)
    {
        // validation for constraint: int
        if (!is_null($idOpcao) && !(is_int($idOpcao) || ctype_digit($idOpcao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idOpcao, true), gettype($idOpcao)), __LINE__);
        }
        $this->IdOpcao = $idOpcao;
        return $this;
    }
}
