<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CriarConfiguracoesTransicao StructType
 * Meta information extracted from the WSDL
 * - type: tns:CriarConfiguracoesTransicao
 * @subpackage Structs
 */
class CriarConfiguracoesTransicao extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IDSequencia
     * @var int
     */
    public $IDSequencia;
    /**
     * The IdModTransicao
     * @var int
     */
    public $IdModTransicao;
    /**
     * The Descricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Descricao;
    /**
     * The DESABILITAR_GRPS
     * @var int
     */
    public $DESABILITAR_GRPS;
    /**
     * The CodMsg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CodMsg;
    /**
     * The IDTerminal
     * @var int
     */
    public $IDTerminal;
    /**
     * Constructor method for CriarConfiguracoesTransicao
     * @uses CriarConfiguracoesTransicao::setUsuario()
     * @uses CriarConfiguracoesTransicao::setSenha()
     * @uses CriarConfiguracoesTransicao::setIDSequencia()
     * @uses CriarConfiguracoesTransicao::setIdModTransicao()
     * @uses CriarConfiguracoesTransicao::setDescricao()
     * @uses CriarConfiguracoesTransicao::setDESABILITAR_GRPS()
     * @uses CriarConfiguracoesTransicao::setCodMsg()
     * @uses CriarConfiguracoesTransicao::setIDTerminal()
     * @param string $usuario
     * @param string $senha
     * @param int $iDSequencia
     * @param int $idModTransicao
     * @param string $descricao
     * @param int $dESABILITAR_GRPS
     * @param string $codMsg
     * @param int $iDTerminal
     */
    public function __construct($usuario = null, $senha = null, $iDSequencia = null, $idModTransicao = null, $descricao = null, $dESABILITAR_GRPS = null, $codMsg = null, $iDTerminal = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIDSequencia($iDSequencia)
            ->setIdModTransicao($idModTransicao)
            ->setDescricao($descricao)
            ->setDESABILITAR_GRPS($dESABILITAR_GRPS)
            ->setCodMsg($codMsg)
            ->setIDTerminal($iDTerminal);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\CriarConfiguracoesTransicao
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\CriarConfiguracoesTransicao
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IDSequencia value
     * @return int|null
     */
    public function getIDSequencia()
    {
        return $this->IDSequencia;
    }
    /**
     * Set IDSequencia value
     * @param int $iDSequencia
     * @return \StructType\CriarConfiguracoesTransicao
     */
    public function setIDSequencia($iDSequencia = null)
    {
        // validation for constraint: int
        if (!is_null($iDSequencia) && !(is_int($iDSequencia) || ctype_digit($iDSequencia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDSequencia, true), gettype($iDSequencia)), __LINE__);
        }
        $this->IDSequencia = $iDSequencia;
        return $this;
    }
    /**
     * Get IdModTransicao value
     * @return int|null
     */
    public function getIdModTransicao()
    {
        return $this->IdModTransicao;
    }
    /**
     * Set IdModTransicao value
     * @param int $idModTransicao
     * @return \StructType\CriarConfiguracoesTransicao
     */
    public function setIdModTransicao($idModTransicao = null)
    {
        // validation for constraint: int
        if (!is_null($idModTransicao) && !(is_int($idModTransicao) || ctype_digit($idModTransicao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idModTransicao, true), gettype($idModTransicao)), __LINE__);
        }
        $this->IdModTransicao = $idModTransicao;
        return $this;
    }
    /**
     * Get Descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->Descricao;
    }
    /**
     * Set Descricao value
     * @param string $descricao
     * @return \StructType\CriarConfiguracoesTransicao
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->Descricao = $descricao;
        return $this;
    }
    /**
     * Get DESABILITAR_GRPS value
     * @return int|null
     */
    public function getDESABILITAR_GRPS()
    {
        return $this->DESABILITAR_GRPS;
    }
    /**
     * Set DESABILITAR_GRPS value
     * @param int $dESABILITAR_GRPS
     * @return \StructType\CriarConfiguracoesTransicao
     */
    public function setDESABILITAR_GRPS($dESABILITAR_GRPS = null)
    {
        // validation for constraint: int
        if (!is_null($dESABILITAR_GRPS) && !(is_int($dESABILITAR_GRPS) || ctype_digit($dESABILITAR_GRPS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dESABILITAR_GRPS, true), gettype($dESABILITAR_GRPS)), __LINE__);
        }
        $this->DESABILITAR_GRPS = $dESABILITAR_GRPS;
        return $this;
    }
    /**
     * Get CodMsg value
     * @return string|null
     */
    public function getCodMsg()
    {
        return $this->CodMsg;
    }
    /**
     * Set CodMsg value
     * @param string $codMsg
     * @return \StructType\CriarConfiguracoesTransicao
     */
    public function setCodMsg($codMsg = null)
    {
        // validation for constraint: string
        if (!is_null($codMsg) && !is_string($codMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codMsg, true), gettype($codMsg)), __LINE__);
        }
        $this->CodMsg = $codMsg;
        return $this;
    }
    /**
     * Get IDTerminal value
     * @return int|null
     */
    public function getIDTerminal()
    {
        return $this->IDTerminal;
    }
    /**
     * Set IDTerminal value
     * @param int $iDTerminal
     * @return \StructType\CriarConfiguracoesTransicao
     */
    public function setIDTerminal($iDTerminal = null)
    {
        // validation for constraint: int
        if (!is_null($iDTerminal) && !(is_int($iDTerminal) || ctype_digit($iDTerminal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDTerminal, true), gettype($iDTerminal)), __LINE__);
        }
        $this->IDTerminal = $iDTerminal;
        return $this;
    }
}
