<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ComandoIscaCCID StructType
 * Meta information extracted from the WSDL
 * - type: tns:ComandoIscaCCID
 * @subpackage Structs
 */
class ComandoIscaCCID extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdIsca
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IdIsca;
    /**
     * Constructor method for ComandoIscaCCID
     * @uses ComandoIscaCCID::setUsuario()
     * @uses ComandoIscaCCID::setSenha()
     * @uses ComandoIscaCCID::setIdIsca()
     * @param string $usuario
     * @param string $senha
     * @param string $idIsca
     */
    public function __construct($usuario = null, $senha = null, $idIsca = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdIsca($idIsca);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ComandoIscaCCID
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ComandoIscaCCID
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdIsca value
     * @return string|null
     */
    public function getIdIsca()
    {
        return $this->IdIsca;
    }
    /**
     * Set IdIsca value
     * @param string $idIsca
     * @return \StructType\ComandoIscaCCID
     */
    public function setIdIsca($idIsca = null)
    {
        // validation for constraint: string
        if (!is_null($idIsca) && !is_string($idIsca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idIsca, true), gettype($idIsca)), __LINE__);
        }
        $this->IdIsca = $idIsca;
        return $this;
    }
}
