<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssociarMensagemFormatada StructType
 * Meta information extracted from the WSDL
 * - type: tns:AssociarMensagemFormatada
 * @subpackage Structs
 */
class AssociarMensagemFormatada extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdVeiculo
     * @var int
     */
    public $IdVeiculo;
    /**
     * The idGrupo
     * @var int
     */
    public $idGrupo;
    /**
     * Constructor method for AssociarMensagemFormatada
     * @uses AssociarMensagemFormatada::setUsuario()
     * @uses AssociarMensagemFormatada::setSenha()
     * @uses AssociarMensagemFormatada::setIdVeiculo()
     * @uses AssociarMensagemFormatada::setIdGrupo()
     * @param string $usuario
     * @param string $senha
     * @param int $idVeiculo
     * @param int $idGrupo
     */
    public function __construct($usuario = null, $senha = null, $idVeiculo = null, $idGrupo = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdVeiculo($idVeiculo)
            ->setIdGrupo($idGrupo);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\AssociarMensagemFormatada
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\AssociarMensagemFormatada
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdVeiculo value
     * @return int|null
     */
    public function getIdVeiculo()
    {
        return $this->IdVeiculo;
    }
    /**
     * Set IdVeiculo value
     * @param int $idVeiculo
     * @return \StructType\AssociarMensagemFormatada
     */
    public function setIdVeiculo($idVeiculo = null)
    {
        // validation for constraint: int
        if (!is_null($idVeiculo) && !(is_int($idVeiculo) || ctype_digit($idVeiculo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idVeiculo, true), gettype($idVeiculo)), __LINE__);
        }
        $this->IdVeiculo = $idVeiculo;
        return $this;
    }
    /**
     * Get idGrupo value
     * @return int|null
     */
    public function getIdGrupo()
    {
        return $this->idGrupo;
    }
    /**
     * Set idGrupo value
     * @param int $idGrupo
     * @return \StructType\AssociarMensagemFormatada
     */
    public function setIdGrupo($idGrupo = null)
    {
        // validation for constraint: int
        if (!is_null($idGrupo) && !(is_int($idGrupo) || ctype_digit($idGrupo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idGrupo, true), gettype($idGrupo)), __LINE__);
        }
        $this->idGrupo = $idGrupo;
        return $this;
    }
}
