<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Versao ServiceType
 * @subpackage Services
 */
class Versao extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named VersaoWstt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VersaoWstt $parameters
     * @return \StructType\VersaoWsttResponse|bool
     */
    public function VersaoWstt(\StructType\VersaoWstt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VersaoWstt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\VersaoWsttResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
