<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Temperatura ServiceType
 * @subpackage Services
 */
class Temperatura extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TemperaturaAvulsa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TemperaturaAvulsa $parameters
     * @return \StructType\TemperaturaAvulsaResponse|bool
     */
    public function TemperaturaAvulsa(\StructType\TemperaturaAvulsa $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TemperaturaAvulsa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TemperaturaAvulsaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
