<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Salvar ServiceType
 * @subpackage Services
 */
class Salvar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SalvarAlertasAlteradosByCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SalvarAlertasAlteradosByCliente $parameters
     * @return \StructType\SalvarAlertasAlteradosByClienteResponse|bool
     */
    public function SalvarAlertasAlteradosByCliente(\StructType\SalvarAlertasAlteradosByCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SalvarAlertasAlteradosByCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SalvarPosicaoViaOcorrencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SalvarPosicaoViaOcorrencia $parameters
     * @return \StructType\SalvarPosicaoViaOcorrenciaResponse|bool
     */
    public function SalvarPosicaoViaOcorrencia(\StructType\SalvarPosicaoViaOcorrencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SalvarPosicaoViaOcorrencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SalvarAlertasAlteradosByClienteResponse|\StructType\SalvarPosicaoViaOcorrenciaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
