<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Limpar ServiceType
 * @subpackage Services
 */
class Limpar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LimparCercasRastreador
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LimparCercasRastreador $parameters
     * @return \StructType\LimparCercasRastreadorResponse|bool
     */
    public function LimparCercasRastreador(\StructType\LimparCercasRastreador $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LimparCercasRastreador($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LimparAlvosRastreador
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LimparAlvosRastreador $parameters
     * @return \StructType\LimparAlvosRastreadorResponse|bool
     */
    public function LimparAlvosRastreador(\StructType\LimparAlvosRastreador $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LimparAlvosRastreador($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LimparRotasRastreador
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LimparRotasRastreador $parameters
     * @return \StructType\LimparRotasRastreadorResponse|bool
     */
    public function LimparRotasRastreador(\StructType\LimparRotasRastreador $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LimparRotasRastreador($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LimparMensagemFormatada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LimparMensagemFormatada $parameters
     * @return \StructType\LimparMensagemFormatadaResponse|bool
     */
    public function LimparMensagemFormatada(\StructType\LimparMensagemFormatada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LimparMensagemFormatada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LimparAlvosRastreadorResponse|\StructType\LimparCercasRastreadorResponse|\StructType\LimparMensagemFormatadaResponse|\StructType\LimparRotasRastreadorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
