<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Gera ServiceType
 * @subpackage Services
 */
class Gera extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GeraSenhaDesbloqueio
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeraSenhaDesbloqueio $parameters
     * @return \StructType\GeraSenhaDesbloqueioResponse|bool
     */
    public function GeraSenhaDesbloqueio(\StructType\GeraSenhaDesbloqueio $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GeraSenhaDesbloqueio($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GeraSenhaAutorizacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeraSenhaAutorizacao $parameters
     * @return \StructType\GeraSenhaAutorizacaoResponse|bool
     */
    public function GeraSenhaAutorizacao(\StructType\GeraSenhaAutorizacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GeraSenhaAutorizacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GeraSenhaAutorizacaoResponse|\StructType\GeraSenhaDesbloqueioResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
