<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Detalhar ServiceType
 * @subpackage Services
 */
class Detalhar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DetalharVeiculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DetalharVeiculo $parameters
     * @return \StructType\DetalharVeiculoResponse|bool
     */
    public function DetalharVeiculo(\StructType\DetalharVeiculo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DetalharVeiculo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DetalharVeiculoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
