<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Autorizar ServiceType
 * @subpackage Services
 */
class Autorizar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Autorizar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Autorizar $parameters
     * @return \StructType\AutorizarResponse|bool
     */
    public function Autorizar(\StructType\Autorizar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Autorizar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AutorizarResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
