<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://wstt.omnilink.com.br/iasws/iasws.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://wstt.omnilink.com.br/iasws/iasws.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Obtem ServiceType
 */
$obtem = new \ServiceType\Obtem($options);
/**
 * Sample call for ObtemRastreadores_Todos operation/method
 */
if ($obtem->ObtemRastreadores_Todos(new \StructType\ObtemRastreadores_Todos()) !== false) {
    print_r($obtem->getResult());
} else {
    print_r($obtem->getLastError());
}
/**
 * Sample call for ObtemEventosNormais operation/method
 */
if ($obtem->ObtemEventosNormais(new \StructType\ObtemEventosNormais()) !== false) {
    print_r($obtem->getResult());
} else {
    print_r($obtem->getLastError());
}
/**
 * Sample call for ObtemEventosCtrl operation/method
 */
if ($obtem->ObtemEventosCtrl(new \StructType\ObtemEventosCtrl()) !== false) {
    print_r($obtem->getResult());
} else {
    print_r($obtem->getLastError());
}
/**
 * Sample call for ObtemEventosMF operation/method
 */
if ($obtem->ObtemEventosMF(new \StructType\ObtemEventosMF()) !== false) {
    print_r($obtem->getResult());
} else {
    print_r($obtem->getLastError());
}
/**
 * Sample call for ObtemStatusComando operation/method
 */
if ($obtem->ObtemStatusComando(new \StructType\ObtemStatusComando()) !== false) {
    print_r($obtem->getResult());
} else {
    print_r($obtem->getLastError());
}
/**
 * Sample call for ObtemEventos operation/method
 */
if ($obtem->ObtemEventos(new \StructType\ObtemEventos()) !== false) {
    print_r($obtem->getResult());
} else {
    print_r($obtem->getLastError());
}
/**
 * Sample call for ObtemMensagensPreDefinidas operation/method
 */
if ($obtem->ObtemMensagensPreDefinidas(new \StructType\ObtemMensagensPreDefinidas()) !== false) {
    print_r($obtem->getResult());
} else {
    print_r($obtem->getLastError());
}
/**
 * Sample call for ObtemEventosOmnifrota operation/method
 */
if ($obtem->ObtemEventosOmnifrota(new \StructType\ObtemEventosOmnifrota()) !== false) {
    print_r($obtem->getResult());
} else {
    print_r($obtem->getLastError());
}
/**
 * Sample call for ObtemEventosIscas operation/method
 */
if ($obtem->ObtemEventosIscas(new \StructType\ObtemEventosIscas()) !== false) {
    print_r($obtem->getResult());
} else {
    print_r($obtem->getLastError());
}
/**
 * Sample call for ObtemListaPerfilCercaAlvo operation/method
 */
if ($obtem->ObtemListaPerfilCercaAlvo(new \StructType\ObtemListaPerfilCercaAlvo()) !== false) {
    print_r($obtem->getResult());
} else {
    print_r($obtem->getLastError());
}
/**
 * Sample call for ObtemEventosImportacao operation/method
 */
if ($obtem->ObtemEventosImportacao(new \StructType\ObtemEventosImportacao()) !== false) {
    print_r($obtem->getResult());
} else {
    print_r($obtem->getLastError());
}
/**
 * Sample call for ObtemRastreadoresTodosIscas operation/method
 */
if ($obtem->ObtemRastreadoresTodosIscas(new \StructType\ObtemRastreadoresTodosIscas()) !== false) {
    print_r($obtem->getResult());
} else {
    print_r($obtem->getLastError());
}
/**
 * Sample call for ObtemRastreadoresTodosOmnifrota operation/method
 */
if ($obtem->ObtemRastreadoresTodosOmnifrota(new \StructType\ObtemRastreadoresTodosOmnifrota()) !== false) {
    print_r($obtem->getResult());
} else {
    print_r($obtem->getLastError());
}
/**
 * Samples for Bloquear ServiceType
 */
$bloquear = new \ServiceType\Bloquear($options);
/**
 * Sample call for BloquearRastreador operation/method
 */
if ($bloquear->BloquearRastreador(new \StructType\BloquearRastreador()) !== false) {
    print_r($bloquear->getResult());
} else {
    print_r($bloquear->getLastError());
}
/**
 * Samples for Desbloquear ServiceType
 */
$desbloquear = new \ServiceType\Desbloquear($options);
/**
 * Sample call for DesbloquearRastreador operation/method
 */
if ($desbloquear->DesbloquearRastreador(new \StructType\DesbloquearRastreador()) !== false) {
    print_r($desbloquear->getResult());
} else {
    print_r($desbloquear->getLastError());
}
/**
 * Samples for Ativar ServiceType
 */
$ativar = new \ServiceType\Ativar($options);
/**
 * Sample call for AtivarModoRastreado operation/method
 */
if ($ativar->AtivarModoRastreado(new \StructType\AtivarModoRastreado()) !== false) {
    print_r($ativar->getResult());
} else {
    print_r($ativar->getLastError());
}
/**
 * Sample call for AtivarModoInterativo operation/method
 */
if ($ativar->AtivarModoInterativo(new \StructType\AtivarModoInterativo()) !== false) {
    print_r($ativar->getResult());
} else {
    print_r($ativar->getLastError());
}
/**
 * Samples for Desativar ServiceType
 */
$desativar = new \ServiceType\Desativar($options);
/**
 * Sample call for Desativar operation/method
 */
if ($desativar->Desativar(new \StructType\Desativar()) !== false) {
    print_r($desativar->getResult());
} else {
    print_r($desativar->getLastError());
}
/**
 * Sample call for DesativarConfiguracoesConfiguracaoHistorico operation/method
 */
if ($desativar->DesativarConfiguracoesConfiguracaoHistorico(new \StructType\DesativarConfiguracoesConfiguracaoHistorico()) !== false) {
    print_r($desativar->getResult());
} else {
    print_r($desativar->getLastError());
}
/**
 * Sample call for DesativarConfiguracoesTransmissao operation/method
 */
if ($desativar->DesativarConfiguracoesTransmissao(new \StructType\DesativarConfiguracoesTransmissao()) !== false) {
    print_r($desativar->getResult());
} else {
    print_r($desativar->getLastError());
}
/**
 * Sample call for DesativarConfiguracoesOpcoesSe operation/method
 */
if ($desativar->DesativarConfiguracoesOpcoesSe(new \StructType\DesativarConfiguracoesOpcoesSe()) !== false) {
    print_r($desativar->getResult());
} else {
    print_r($desativar->getLastError());
}
/**
 * Sample call for DesativarConfiguracoesTransicao operation/method
 */
if ($desativar->DesativarConfiguracoesTransicao(new \StructType\DesativarConfiguracoesTransicao()) !== false) {
    print_r($desativar->getResult());
} else {
    print_r($desativar->getLastError());
}
/**
 * Sample call for DesativarConfiguracoesTemperatura operation/method
 */
if ($desativar->DesativarConfiguracoesTemperatura(new \StructType\DesativarConfiguracoesTemperatura()) !== false) {
    print_r($desativar->getResult());
} else {
    print_r($desativar->getLastError());
}
/**
 * Sample call for DesativarConfiguracoesInterativo operation/method
 */
if ($desativar->DesativarConfiguracoesInterativo(new \StructType\DesativarConfiguracoesInterativo()) !== false) {
    print_r($desativar->getResult());
} else {
    print_r($desativar->getLastError());
}
/**
 * Sample call for DesativarConfiguracoesSenhas operation/method
 */
if ($desativar->DesativarConfiguracoesSenhas(new \StructType\DesativarConfiguracoesSenhas()) !== false) {
    print_r($desativar->getResult());
} else {
    print_r($desativar->getLastError());
}
/**
 * Sample call for DesativarConfiguracoesAtuadores operation/method
 */
if ($desativar->DesativarConfiguracoesAtuadores(new \StructType\DesativarConfiguracoesAtuadores()) !== false) {
    print_r($desativar->getResult());
} else {
    print_r($desativar->getLastError());
}
/**
 * Sample call for DesativarConfiguracoesOpcoesSeguranca operation/method
 */
if ($desativar->DesativarConfiguracoesOpcoesSeguranca(new \StructType\DesativarConfiguracoesOpcoesSeguranca()) !== false) {
    print_r($desativar->getResult());
} else {
    print_r($desativar->getLastError());
}
/**
 * Sample call for DesativarConfiguracoesExcecao operation/method
 */
if ($desativar->DesativarConfiguracoesExcecao(new \StructType\DesativarConfiguracoesExcecao()) !== false) {
    print_r($desativar->getResult());
} else {
    print_r($desativar->getLastError());
}
/**
 * Sample call for DesativarConfiguracoesMultiplosSensores operation/method
 */
if ($desativar->DesativarConfiguracoesMultiplosSensores(new \StructType\DesativarConfiguracoesMultiplosSensores()) !== false) {
    print_r($desativar->getResult());
} else {
    print_r($desativar->getLastError());
}
/**
 * Sample call for DesativarConfiguracoesUmidade operation/method
 */
if ($desativar->DesativarConfiguracoesUmidade(new \StructType\DesativarConfiguracoesUmidade()) !== false) {
    print_r($desativar->getResult());
} else {
    print_r($desativar->getLastError());
}
/**
 * Samples for Envia ServiceType
 */
$envia = new \ServiceType\Envia($options);
/**
 * Sample call for EnviaBip operation/method
 */
if ($envia->EnviaBip(new \StructType\EnviaBip()) !== false) {
    print_r($envia->getResult());
} else {
    print_r($envia->getLastError());
}
/**
 * Samples for Deslacrar ServiceType
 */
$deslacrar = new \ServiceType\Deslacrar($options);
/**
 * Sample call for DeslacrarBau operation/method
 */
if ($deslacrar->DeslacrarBau(new \StructType\DeslacrarBau()) !== false) {
    print_r($deslacrar->getResult());
} else {
    print_r($deslacrar->getLastError());
}
/**
 * Sample call for DeslacrarCabine operation/method
 */
if ($deslacrar->DeslacrarCabine(new \StructType\DeslacrarCabine()) !== false) {
    print_r($deslacrar->getResult());
} else {
    print_r($deslacrar->getLastError());
}
/**
 * Sample call for DeslacrarCarreta operation/method
 */
if ($deslacrar->DeslacrarCarreta(new \StructType\DeslacrarCarreta()) !== false) {
    print_r($deslacrar->getResult());
} else {
    print_r($deslacrar->getLastError());
}
/**
 * Sample call for DeslacrarMotor operation/method
 */
if ($deslacrar->DeslacrarMotor(new \StructType\DeslacrarMotor()) !== false) {
    print_r($deslacrar->getResult());
} else {
    print_r($deslacrar->getLastError());
}
/**
 * Samples for Lacrar ServiceType
 */
$lacrar = new \ServiceType\Lacrar($options);
/**
 * Sample call for LacrarBau operation/method
 */
if ($lacrar->LacrarBau(new \StructType\LacrarBau()) !== false) {
    print_r($lacrar->getResult());
} else {
    print_r($lacrar->getLastError());
}
/**
 * Sample call for LacrarCabine operation/method
 */
if ($lacrar->LacrarCabine(new \StructType\LacrarCabine()) !== false) {
    print_r($lacrar->getResult());
} else {
    print_r($lacrar->getLastError());
}
/**
 * Sample call for LacrarCarreta operation/method
 */
if ($lacrar->LacrarCarreta(new \StructType\LacrarCarreta()) !== false) {
    print_r($lacrar->getResult());
} else {
    print_r($lacrar->getLastError());
}
/**
 * Sample call for LacrarMotor operation/method
 */
if ($lacrar->LacrarMotor(new \StructType\LacrarMotor()) !== false) {
    print_r($lacrar->getResult());
} else {
    print_r($lacrar->getLastError());
}
/**
 * Samples for Autorizar ServiceType
 */
$autorizar = new \ServiceType\Autorizar($options);
/**
 * Sample call for Autorizar operation/method
 */
if ($autorizar->Autorizar(new \StructType\Autorizar()) !== false) {
    print_r($autorizar->getResult());
} else {
    print_r($autorizar->getLastError());
}
/**
 * Samples for Temperatura ServiceType
 */
$temperatura = new \ServiceType\Temperatura($options);
/**
 * Sample call for TemperaturaAvulsa operation/method
 */
if ($temperatura->TemperaturaAvulsa(new \StructType\TemperaturaAvulsa()) !== false) {
    print_r($temperatura->getResult());
} else {
    print_r($temperatura->getLastError());
}
/**
 * Samples for Mensagem ServiceType
 */
$mensagem = new \ServiceType\Mensagem($options);
/**
 * Sample call for MensagemLivre operation/method
 */
if ($mensagem->MensagemLivre(new \StructType\MensagemLivre()) !== false) {
    print_r($mensagem->getResult());
} else {
    print_r($mensagem->getLastError());
}
/**
 * Samples for Pede ServiceType
 */
$pede = new \ServiceType\Pede($options);
/**
 * Sample call for PedePosicaoAvulsa operation/method
 */
if ($pede->PedePosicaoAvulsa(new \StructType\PedePosicaoAvulsa()) !== false) {
    print_r($pede->getResult());
} else {
    print_r($pede->getLastError());
}
/**
 * Sample call for PedeHistorico operation/method
 */
if ($pede->PedeHistorico(new \StructType\PedeHistorico()) !== false) {
    print_r($pede->getResult());
} else {
    print_r($pede->getLastError());
}
/**
 * Samples for Liberar ServiceType
 */
$liberar = new \ServiceType\Liberar($options);
/**
 * Sample call for LiberarQuintaRoda operation/method
 */
if ($liberar->LiberarQuintaRoda(new \StructType\LiberarQuintaRoda()) !== false) {
    print_r($liberar->getResult());
} else {
    print_r($liberar->getLastError());
}
/**
 * Samples for Listar ServiceType
 */
$listar = new \ServiceType\Listar($options);
/**
 * Sample call for ListarAlvos operation/method
 */
if ($listar->ListarAlvos(new \StructType\ListarAlvos()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarAlvosIndexados operation/method
 */
if ($listar->ListarAlvosIndexados(new \StructType\ListarAlvosIndexados()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarAlvoAssociadoVeiculo operation/method
 */
if ($listar->ListarAlvoAssociadoVeiculo(new \StructType\ListarAlvoAssociadoVeiculo()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarGrupoAlvo operation/method
 */
if ($listar->ListarGrupoAlvo(new \StructType\ListarGrupoAlvo()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarGrupoMensagemFormatadaDetalhe operation/method
 */
if ($listar->ListarGrupoMensagemFormatadaDetalhe(new \StructType\ListarGrupoMensagemFormatadaDetalhe()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgAtuadoresByIdSequencia operation/method
 */
if ($listar->ListarCfgAtuadoresByIdSequencia(new \StructType\ListarCfgAtuadoresByIdSequencia()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgAtuadoresByIdCliente operation/method
 */
if ($listar->ListarCfgAtuadoresByIdCliente(new \StructType\ListarCfgAtuadoresByIdCliente()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgExcecaoByIdSequencia operation/method
 */
if ($listar->ListarCfgExcecaoByIdSequencia(new \StructType\ListarCfgExcecaoByIdSequencia()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgExcecaoByIdCliente operation/method
 */
if ($listar->ListarCfgExcecaoByIdCliente(new \StructType\ListarCfgExcecaoByIdCliente()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgInterativoByIdSequencia operation/method
 */
if ($listar->ListarCfgInterativoByIdSequencia(new \StructType\ListarCfgInterativoByIdSequencia()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgInterativoByIdCliente operation/method
 */
if ($listar->ListarCfgInterativoByIdCliente(new \StructType\ListarCfgInterativoByIdCliente()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgLogByIdSequencia operation/method
 */
if ($listar->ListarCfgLogByIdSequencia(new \StructType\ListarCfgLogByIdSequencia()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgLogByIdCliente operation/method
 */
if ($listar->ListarCfgLogByIdCliente(new \StructType\ListarCfgLogByIdCliente()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgOpcoesSeByIdSequencia operation/method
 */
if ($listar->ListarCfgOpcoesSeByIdSequencia(new \StructType\ListarCfgOpcoesSeByIdSequencia()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgOpcoesSeByIdCliente operation/method
 */
if ($listar->ListarCfgOpcoesSeByIdCliente(new \StructType\ListarCfgOpcoesSeByIdCliente()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgOpcoesSegByIdSequencia operation/method
 */
if ($listar->ListarCfgOpcoesSegByIdSequencia(new \StructType\ListarCfgOpcoesSegByIdSequencia()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgOpcoesSegByIdCliente operation/method
 */
if ($listar->ListarCfgOpcoesSegByIdCliente(new \StructType\ListarCfgOpcoesSegByIdCliente()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgOpcoesSegByIdClientePerfil operation/method
 */
if ($listar->ListarCfgOpcoesSegByIdClientePerfil(new \StructType\ListarCfgOpcoesSegByIdClientePerfil()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgSenhasByIdSequencia operation/method
 */
if ($listar->ListarCfgSenhasByIdSequencia(new \StructType\ListarCfgSenhasByIdSequencia()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgSenhasByIdCliente operation/method
 */
if ($listar->ListarCfgSenhasByIdCliente(new \StructType\ListarCfgSenhasByIdCliente()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgTemperaturaByIdSequencia operation/method
 */
if ($listar->ListarCfgTemperaturaByIdSequencia(new \StructType\ListarCfgTemperaturaByIdSequencia()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgTemperaturaByIdCliente operation/method
 */
if ($listar->ListarCfgTemperaturaByIdCliente(new \StructType\ListarCfgTemperaturaByIdCliente()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgTransicaoByIdSequencia operation/method
 */
if ($listar->ListarCfgTransicaoByIdSequencia(new \StructType\ListarCfgTransicaoByIdSequencia()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgTransicaoByIdCliente operation/method
 */
if ($listar->ListarCfgTransicaoByIdCliente(new \StructType\ListarCfgTransicaoByIdCliente()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgTransicao operation/method
 */
if ($listar->ListarCfgTransicao(new \StructType\ListarCfgTransicao()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgTransmissaoByIdSequencia operation/method
 */
if ($listar->ListarCfgTransmissaoByIdSequencia(new \StructType\ListarCfgTransmissaoByIdSequencia()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgTransmissaoByIdCliente operation/method
 */
if ($listar->ListarCfgTransmissaoByIdCliente(new \StructType\ListarCfgTransmissaoByIdCliente()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarPerfilConfiguracaoByIdCliente operation/method
 */
if ($listar->ListarPerfilConfiguracaoByIdCliente(new \StructType\ListarPerfilConfiguracaoByIdCliente()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarOperacaoByCliente operation/method
 */
if ($listar->ListarOperacaoByCliente(new \StructType\ListarOperacaoByCliente()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarItensOperacaoByOperacao operation/method
 */
if ($listar->ListarItensOperacaoByOperacao(new \StructType\ListarItensOperacaoByOperacao()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarGrupoCercas operation/method
 */
if ($listar->ListarGrupoCercas(new \StructType\ListarGrupoCercas()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCercas operation/method
 */
if ($listar->ListarCercas(new \StructType\ListarCercas()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCercasIndexado operation/method
 */
if ($listar->ListarCercasIndexado(new \StructType\ListarCercasIndexado()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgAtuadoresByIdTerminal operation/method
 */
if ($listar->ListarCfgAtuadoresByIdTerminal(new \StructType\ListarCfgAtuadoresByIdTerminal()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgInterativoByIdTerminal operation/method
 */
if ($listar->ListarCfgInterativoByIdTerminal(new \StructType\ListarCfgInterativoByIdTerminal()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgLogByIdTerminal operation/method
 */
if ($listar->ListarCfgLogByIdTerminal(new \StructType\ListarCfgLogByIdTerminal()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgOpcoesSeByIdTerminal operation/method
 */
if ($listar->ListarCfgOpcoesSeByIdTerminal(new \StructType\ListarCfgOpcoesSeByIdTerminal()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgOpcoesSegByIdTerminal operation/method
 */
if ($listar->ListarCfgOpcoesSegByIdTerminal(new \StructType\ListarCfgOpcoesSegByIdTerminal()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgSenhasByIdTerminal operation/method
 */
if ($listar->ListarCfgSenhasByIdTerminal(new \StructType\ListarCfgSenhasByIdTerminal()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgTemperaturaByIdTerminal operation/method
 */
if ($listar->ListarCfgTemperaturaByIdTerminal(new \StructType\ListarCfgTemperaturaByIdTerminal()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgTransmissaoByIdTerminal operation/method
 */
if ($listar->ListarCfgTransmissaoByIdTerminal(new \StructType\ListarCfgTransmissaoByIdTerminal()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgExcecaoByIdTerminal operation/method
 */
if ($listar->ListarCfgExcecaoByIdTerminal(new \StructType\ListarCfgExcecaoByIdTerminal()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarGrupoRotas operation/method
 */
if ($listar->ListarGrupoRotas(new \StructType\ListarGrupoRotas()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarRotas operation/method
 */
if ($listar->ListarRotas(new \StructType\ListarRotas()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarRotasIndexado operation/method
 */
if ($listar->ListarRotasIndexado(new \StructType\ListarRotasIndexado()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarModTransicao operation/method
 */
if ($listar->ListarModTransicao(new \StructType\ListarModTransicao()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarTodosModTransicao operation/method
 */
if ($listar->ListarTodosModTransicao(new \StructType\ListarTodosModTransicao()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarMensagemPredefinida operation/method
 */
if ($listar->ListarMensagemPredefinida(new \StructType\ListarMensagemPredefinida()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarTodosMensagemPredefinida operation/method
 */
if ($listar->ListarTodosMensagemPredefinida(new \StructType\ListarTodosMensagemPredefinida()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarTodosMensagemPredefinidaAssociada operation/method
 */
if ($listar->ListarTodosMensagemPredefinidaAssociada(new \StructType\ListarTodosMensagemPredefinidaAssociada()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarGrupoMensagemFormatada operation/method
 */
if ($listar->ListarGrupoMensagemFormatada(new \StructType\ListarGrupoMensagemFormatada()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarTodosGrupoMensagemFormatada operation/method
 */
if ($listar->ListarTodosGrupoMensagemFormatada(new \StructType\ListarTodosGrupoMensagemFormatada()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarMensagemFormatada operation/method
 */
if ($listar->ListarMensagemFormatada(new \StructType\ListarMensagemFormatada()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarTodosMensagemFormatada operation/method
 */
if ($listar->ListarTodosMensagemFormatada(new \StructType\ListarTodosMensagemFormatada()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarParametroVeiculo operation/method
 */
if ($listar->ListarParametroVeiculo(new \StructType\ListarParametroVeiculo()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarParametrosVeiculoSecao operation/method
 */
if ($listar->ListarParametrosVeiculoSecao(new \StructType\ListarParametrosVeiculoSecao()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarPerfilParametroVeiculo operation/method
 */
if ($listar->ListarPerfilParametroVeiculo(new \StructType\ListarPerfilParametroVeiculo()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCercaAssociadoVeiculo operation/method
 */
if ($listar->ListarCercaAssociadoVeiculo(new \StructType\ListarCercaAssociadoVeiculo()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarRotaAssociadoVeiculo operation/method
 */
if ($listar->ListarRotaAssociadoVeiculo(new \StructType\ListarRotaAssociadoVeiculo()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgMultiplosSensoresByIdSequencia operation/method
 */
if ($listar->ListarCfgMultiplosSensoresByIdSequencia(new \StructType\ListarCfgMultiplosSensoresByIdSequencia()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgMultiplosSensoresByIdCliente operation/method
 */
if ($listar->ListarCfgMultiplosSensoresByIdCliente(new \StructType\ListarCfgMultiplosSensoresByIdCliente()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgMultiplosSensoresByIdTerminal operation/method
 */
if ($listar->ListarCfgMultiplosSensoresByIdTerminal(new \StructType\ListarCfgMultiplosSensoresByIdTerminal()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarItensCfgModTransicao operation/method
 */
if ($listar->ListarItensCfgModTransicao(new \StructType\ListarItensCfgModTransicao()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarMensagemFormatadaAssociadaOrigem operation/method
 */
if ($listar->ListarMensagemFormatadaAssociadaOrigem(new \StructType\ListarMensagemFormatadaAssociadaOrigem()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarMensagemFormatadaAssociadaDestino operation/method
 */
if ($listar->ListarMensagemFormatadaAssociadaDestino(new \StructType\ListarMensagemFormatadaAssociadaDestino()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarMensagemFormatadaEnviada operation/method
 */
if ($listar->ListarMensagemFormatadaEnviada(new \StructType\ListarMensagemFormatadaEnviada()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarFuncoesProgramadas operation/method
 */
if ($listar->ListarFuncoesProgramadas(new \StructType\ListarFuncoesProgramadas()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgUmidadeByIdSequencia operation/method
 */
if ($listar->ListarCfgUmidadeByIdSequencia(new \StructType\ListarCfgUmidadeByIdSequencia()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgUmidadeByIdCliente operation/method
 */
if ($listar->ListarCfgUmidadeByIdCliente(new \StructType\ListarCfgUmidadeByIdCliente()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgUmidadeByIdTerminal operation/method
 */
if ($listar->ListarCfgUmidadeByIdTerminal(new \StructType\ListarCfgUmidadeByIdTerminal()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarGrupoAlvoAssociadoVeiculoDetalhe operation/method
 */
if ($listar->ListarGrupoAlvoAssociadoVeiculoDetalhe(new \StructType\ListarGrupoAlvoAssociadoVeiculoDetalhe()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarGrupoCercaAssociadoVeiculoDetalhe operation/method
 */
if ($listar->ListarGrupoCercaAssociadoVeiculoDetalhe(new \StructType\ListarGrupoCercaAssociadoVeiculoDetalhe()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarGrupoRotaAssociadoVeiculoDetalhe operation/method
 */
if ($listar->ListarGrupoRotaAssociadoVeiculoDetalhe(new \StructType\ListarGrupoRotaAssociadoVeiculoDetalhe()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarGrupoAlvoEnviadoVeiculoDetalhe operation/method
 */
if ($listar->ListarGrupoAlvoEnviadoVeiculoDetalhe(new \StructType\ListarGrupoAlvoEnviadoVeiculoDetalhe()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarTransmissoesAlvosEnviadoVeiculoDetalhe operation/method
 */
if ($listar->ListarTransmissoesAlvosEnviadoVeiculoDetalhe(new \StructType\ListarTransmissoesAlvosEnviadoVeiculoDetalhe()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarGrupoCercaEnviadoVeiculoDetalhe operation/method
 */
if ($listar->ListarGrupoCercaEnviadoVeiculoDetalhe(new \StructType\ListarGrupoCercaEnviadoVeiculoDetalhe()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarGrupoRotaEnviadoVeiculoDetalhe operation/method
 */
if ($listar->ListarGrupoRotaEnviadoVeiculoDetalhe(new \StructType\ListarGrupoRotaEnviadoVeiculoDetalhe()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarMensagemFormatadaCamposValidacao operation/method
 */
if ($listar->ListarMensagemFormatadaCamposValidacao(new \StructType\ListarMensagemFormatadaCamposValidacao()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarVeiculo operation/method
 */
if ($listar->ListarVeiculo(new \StructType\ListarVeiculo()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarVeiculoTerminal operation/method
 */
if ($listar->ListarVeiculoTerminal(new \StructType\ListarVeiculoTerminal()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarVeiculoTodos operation/method
 */
if ($listar->ListarVeiculoTodos(new \StructType\ListarVeiculoTodos()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarInconsistenciasTabelaTransicao operation/method
 */
if ($listar->ListarInconsistenciasTabelaTransicao(new \StructType\ListarInconsistenciasTabelaTransicao()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarVeiculoSensor operation/method
 */
if ($listar->ListarVeiculoSensor(new \StructType\ListarVeiculoSensor()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarConfiguracaoAlertaComunicacao operation/method
 */
if ($listar->ListarConfiguracaoAlertaComunicacao(new \StructType\ListarConfiguracaoAlertaComunicacao()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarVeiculosTesteComunicacao operation/method
 */
if ($listar->ListarVeiculosTesteComunicacao(new \StructType\ListarVeiculosTesteComunicacao()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarTesteComunicacao operation/method
 */
if ($listar->ListarTesteComunicacao(new \StructType\ListarTesteComunicacao()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarRelatorioEstatisticas operation/method
 */
if ($listar->ListarRelatorioEstatisticas(new \StructType\ListarRelatorioEstatisticas()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarIntervaloPosicaoAutomaticaAtual operation/method
 */
if ($listar->ListarIntervaloPosicaoAutomaticaAtual(new \StructType\ListarIntervaloPosicaoAutomaticaAtual()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarPontosReferencias operation/method
 */
if ($listar->ListarPontosReferencias(new \StructType\ListarPontosReferencias()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarTrocaSinalProprietaria operation/method
 */
if ($listar->ListarTrocaSinalProprietaria(new \StructType\ListarTrocaSinalProprietaria()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarRelatorioEventosEspeciais operation/method
 */
if ($listar->ListarRelatorioEventosEspeciais(new \StructType\ListarRelatorioEventosEspeciais()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarRelatorioEventosOutros operation/method
 */
if ($listar->ListarRelatorioEventosOutros(new \StructType\ListarRelatorioEventosOutros()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarHistoricoTransmissao operation/method
 */
if ($listar->ListarHistoricoTransmissao(new \StructType\ListarHistoricoTransmissao()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarGrupoFuncaoProgramavel operation/method
 */
if ($listar->ListarGrupoFuncaoProgramavel(new \StructType\ListarGrupoFuncaoProgramavel()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarGrupoComFuncProg operation/method
 */
if ($listar->ListarGrupoComFuncProg(new \StructType\ListarGrupoComFuncProg()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarTextoTerminal operation/method
 */
if ($listar->ListarTextoTerminal(new \StructType\ListarTextoTerminal()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarTextoTerminalByID operation/method
 */
if ($listar->ListarTextoTerminalByID(new \StructType\ListarTextoTerminalByID()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarRegra operation/method
 */
if ($listar->ListarRegra(new \StructType\ListarRegra()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarFuncaoProgramada operation/method
 */
if ($listar->ListarFuncaoProgramada(new \StructType\ListarFuncaoProgramada()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarVariaveisPersonalizadasPorTipo operation/method
 */
if ($listar->ListarVariaveisPersonalizadasPorTipo(new \StructType\ListarVariaveisPersonalizadasPorTipo()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarVariaveis operation/method
 */
if ($listar->ListarVariaveis(new \StructType\ListarVariaveis()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarReacaoAutoAll operation/method
 */
if ($listar->ListarReacaoAutoAll(new \StructType\ListarReacaoAutoAll()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarComplementosTelevento operation/method
 */
if ($listar->ListarComplementosTelevento(new \StructType\ListarComplementosTelevento()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarOcorrencias operation/method
 */
if ($listar->ListarOcorrencias(new \StructType\ListarOcorrencias()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarSiglaEstados operation/method
 */
if ($listar->ListarSiglaEstados(new \StructType\ListarSiglaEstados()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCidadesDoEstado operation/method
 */
if ($listar->ListarCidadesDoEstado(new \StructType\ListarCidadesDoEstado()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarClassesDeReferencia operation/method
 */
if ($listar->ListarClassesDeReferencia(new \StructType\ListarClassesDeReferencia()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarPontosDeReferenciaParaExibicao operation/method
 */
if ($listar->ListarPontosDeReferenciaParaExibicao(new \StructType\ListarPontosDeReferenciaParaExibicao()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarVeiculosProximos operation/method
 */
if ($listar->ListarVeiculosProximos(new \StructType\ListarVeiculosProximos()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarEventosDisponiveisToAlerta operation/method
 */
if ($listar->ListarEventosDisponiveisToAlerta(new \StructType\ListarEventosDisponiveisToAlerta()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarParametrosEnviados operation/method
 */
if ($listar->ListarParametrosEnviados(new \StructType\ListarParametrosEnviados()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarOperacoesAssociadas operation/method
 */
if ($listar->ListarOperacoesAssociadas(new \StructType\ListarOperacoesAssociadas()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarItensOperacoesAssociadas operation/method
 */
if ($listar->ListarItensOperacoesAssociadas(new \StructType\ListarItensOperacoesAssociadas()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarMotivos operation/method
 */
if ($listar->ListarMotivos(new \StructType\ListarMotivos()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarSensoresPorVeiculos operation/method
 */
if ($listar->ListarSensoresPorVeiculos(new \StructType\ListarSensoresPorVeiculos()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarConfiguracoesDeOpcao operation/method
 */
if ($listar->ListarConfiguracoesDeOpcao(new \StructType\ListarConfiguracoesDeOpcao()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarSensoresDeAlarme operation/method
 */
if ($listar->ListarSensoresDeAlarme(new \StructType\ListarSensoresDeAlarme()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgExcecaoByIdClientePerfil operation/method
 */
if ($listar->ListarCfgExcecaoByIdClientePerfil(new \StructType\ListarCfgExcecaoByIdClientePerfil()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgTransmissaoByIdClientePerfil operation/method
 */
if ($listar->ListarCfgTransmissaoByIdClientePerfil(new \StructType\ListarCfgTransmissaoByIdClientePerfil()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgInterativoByIdClientePerfil operation/method
 */
if ($listar->ListarCfgInterativoByIdClientePerfil(new \StructType\ListarCfgInterativoByIdClientePerfil()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgAtuadoresByIdClientePerfil operation/method
 */
if ($listar->ListarCfgAtuadoresByIdClientePerfil(new \StructType\ListarCfgAtuadoresByIdClientePerfil()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgOpcoesSeByIdClientePerfil operation/method
 */
if ($listar->ListarCfgOpcoesSeByIdClientePerfil(new \StructType\ListarCfgOpcoesSeByIdClientePerfil()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgSenhasByIdClientePerfil operation/method
 */
if ($listar->ListarCfgSenhasByIdClientePerfil(new \StructType\ListarCfgSenhasByIdClientePerfil()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgLogByIdClientePerfil operation/method
 */
if ($listar->ListarCfgLogByIdClientePerfil(new \StructType\ListarCfgLogByIdClientePerfil()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgTemperaturaByIdClientePerfil operation/method
 */
if ($listar->ListarCfgTemperaturaByIdClientePerfil(new \StructType\ListarCfgTemperaturaByIdClientePerfil()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarMotoristaByIdCliente operation/method
 */
if ($listar->ListarMotoristaByIdCliente(new \StructType\ListarMotoristaByIdCliente()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgUmidadeByIdClientePerfil operation/method
 */
if ($listar->ListarCfgUmidadeByIdClientePerfil(new \StructType\ListarCfgUmidadeByIdClientePerfil()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarTodosMensagemPredefinidaByDestino operation/method
 */
if ($listar->ListarTodosMensagemPredefinidaByDestino(new \StructType\ListarTodosMensagemPredefinidaByDestino()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgIntervaloComunicacaoAutomatica operation/method
 */
if ($listar->ListarCfgIntervaloComunicacaoAutomatica(new \StructType\ListarCfgIntervaloComunicacaoAutomatica()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarEspelhamentosByClienteStatus operation/method
 */
if ($listar->ListarEspelhamentosByClienteStatus(new \StructType\ListarEspelhamentosByClienteStatus()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarPontosDaRota operation/method
 */
if ($listar->ListarPontosDaRota(new \StructType\ListarPontosDaRota()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCfgMultiplosSensoresByIdClientePerfil operation/method
 */
if ($listar->ListarCfgMultiplosSensoresByIdClientePerfil(new \StructType\ListarCfgMultiplosSensoresByIdClientePerfil()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarTransmissoesRotasEnviadoVeiculoDetalhe operation/method
 */
if ($listar->ListarTransmissoesRotasEnviadoVeiculoDetalhe(new \StructType\ListarTransmissoesRotasEnviadoVeiculoDetalhe()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarTransmissoesCercasEnviadoVeiculoDetalhe operation/method
 */
if ($listar->ListarTransmissoesCercasEnviadoVeiculoDetalhe(new \StructType\ListarTransmissoesCercasEnviadoVeiculoDetalhe()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarContratosTecnologia operation/method
 */
if ($listar->ListarContratosTecnologia(new \StructType\ListarContratosTecnologia()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarStatusTransmissaoOperacao operation/method
 */
if ($listar->ListarStatusTransmissaoOperacao(new \StructType\ListarStatusTransmissaoOperacao()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarIscasTodos operation/method
 */
if ($listar->ListarIscasTodos(new \StructType\ListarIscasTodos()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Samples for Buscar ServiceType
 */
$buscar = new \ServiceType\Buscar($options);
/**
 * Sample call for BuscarAlvosLikeNome operation/method
 */
if ($buscar->BuscarAlvosLikeNome(new \StructType\BuscarAlvosLikeNome()) !== false) {
    print_r($buscar->getResult());
} else {
    print_r($buscar->getLastError());
}
/**
 * Sample call for BuscarQtdAlvosGrupo operation/method
 */
if ($buscar->BuscarQtdAlvosGrupo(new \StructType\BuscarQtdAlvosGrupo()) !== false) {
    print_r($buscar->getResult());
} else {
    print_r($buscar->getLastError());
}
/**
 * Sample call for BuscarUltimoIdPost operation/method
 */
if ($buscar->BuscarUltimoIdPost(new \StructType\BuscarUltimoIdPost()) !== false) {
    print_r($buscar->getResult());
} else {
    print_r($buscar->getLastError());
}
/**
 * Sample call for BuscarCercasLikeNome operation/method
 */
if ($buscar->BuscarCercasLikeNome(new \StructType\BuscarCercasLikeNome()) !== false) {
    print_r($buscar->getResult());
} else {
    print_r($buscar->getLastError());
}
/**
 * Sample call for BuscarQtdCercasGrupo operation/method
 */
if ($buscar->BuscarQtdCercasGrupo(new \StructType\BuscarQtdCercasGrupo()) !== false) {
    print_r($buscar->getResult());
} else {
    print_r($buscar->getLastError());
}
/**
 * Sample call for BuscarRotasLikeNome operation/method
 */
if ($buscar->BuscarRotasLikeNome(new \StructType\BuscarRotasLikeNome()) !== false) {
    print_r($buscar->getResult());
} else {
    print_r($buscar->getLastError());
}
/**
 * Sample call for BuscarQtdRotasGrupo operation/method
 */
if ($buscar->BuscarQtdRotasGrupo(new \StructType\BuscarQtdRotasGrupo()) !== false) {
    print_r($buscar->getResult());
} else {
    print_r($buscar->getLastError());
}
/**
 * Sample call for BuscarRotaId operation/method
 */
if ($buscar->BuscarRotaId(new \StructType\BuscarRotaId()) !== false) {
    print_r($buscar->getResult());
} else {
    print_r($buscar->getLastError());
}
/**
 * Sample call for BuscarClasseDeReferencia operation/method
 */
if ($buscar->BuscarClasseDeReferencia(new \StructType\BuscarClasseDeReferencia()) !== false) {
    print_r($buscar->getResult());
} else {
    print_r($buscar->getLastError());
}
/**
 * Sample call for BuscarUltimoIdPostPorCliente operation/method
 */
if ($buscar->BuscarUltimoIdPostPorCliente(new \StructType\BuscarUltimoIdPostPorCliente()) !== false) {
    print_r($buscar->getResult());
} else {
    print_r($buscar->getLastError());
}
/**
 * Samples for Importar ServiceType
 */
$importar = new \ServiceType\Importar($options);
/**
 * Sample call for ImportarAlvo operation/method
 */
if ($importar->ImportarAlvo(new \StructType\ImportarAlvo()) !== false) {
    print_r($importar->getResult());
} else {
    print_r($importar->getLastError());
}
/**
 * Sample call for ImportarCerca operation/method
 */
if ($importar->ImportarCerca(new \StructType\ImportarCerca()) !== false) {
    print_r($importar->getResult());
} else {
    print_r($importar->getLastError());
}
/**
 * Sample call for ImportarRota operation/method
 */
if ($importar->ImportarRota(new \StructType\ImportarRota()) !== false) {
    print_r($importar->getResult());
} else {
    print_r($importar->getLastError());
}
/**
 * Sample call for ImportarCercaRotograma operation/method
 */
if ($importar->ImportarCercaRotograma(new \StructType\ImportarCercaRotograma()) !== false) {
    print_r($importar->getResult());
} else {
    print_r($importar->getLastError());
}
/**
 * Sample call for ImportarMensagemFormatada operation/method
 */
if ($importar->ImportarMensagemFormatada(new \StructType\ImportarMensagemFormatada()) !== false) {
    print_r($importar->getResult());
} else {
    print_r($importar->getLastError());
}
/**
 * Sample call for ImportarPontoDeReferencia operation/method
 */
if ($importar->ImportarPontoDeReferencia(new \StructType\ImportarPontoDeReferencia()) !== false) {
    print_r($importar->getResult());
} else {
    print_r($importar->getLastError());
}
/**
 * Samples for Obter ServiceType
 */
$obter = new \ServiceType\Obter($options);
/**
 * Sample call for ObterMensagemformata operation/method
 */
if ($obter->ObterMensagemformata(new \StructType\ObterMensagemformata()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Samples for Transmitir ServiceType
 */
$transmitir = new \ServiceType\Transmitir($options);
/**
 * Sample call for TransmitirAlvo operation/method
 */
if ($transmitir->TransmitirAlvo(new \StructType\TransmitirAlvo()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirConfiguracoesOpcoesSeguranca operation/method
 */
if ($transmitir->TransmitirConfiguracoesOpcoesSeguranca(new \StructType\TransmitirConfiguracoesOpcoesSeguranca()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirConfiguracoesHistorico operation/method
 */
if ($transmitir->TransmitirConfiguracoesHistorico(new \StructType\TransmitirConfiguracoesHistorico()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirConfiguracoesExcecao operation/method
 */
if ($transmitir->TransmitirConfiguracoesExcecao(new \StructType\TransmitirConfiguracoesExcecao()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirConfiguracoesAtuadores operation/method
 */
if ($transmitir->TransmitirConfiguracoesAtuadores(new \StructType\TransmitirConfiguracoesAtuadores()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirConfiguracoesInterativo operation/method
 */
if ($transmitir->TransmitirConfiguracoesInterativo(new \StructType\TransmitirConfiguracoesInterativo()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirConfiguracoesSenhas operation/method
 */
if ($transmitir->TransmitirConfiguracoesSenhas(new \StructType\TransmitirConfiguracoesSenhas()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirConfiguracoesTemperatura operation/method
 */
if ($transmitir->TransmitirConfiguracoesTemperatura(new \StructType\TransmitirConfiguracoesTemperatura()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirConfiguracoesOpcoesSe operation/method
 */
if ($transmitir->TransmitirConfiguracoesOpcoesSe(new \StructType\TransmitirConfiguracoesOpcoesSe()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirConfguracoesTransmissao operation/method
 */
if ($transmitir->TransmitirConfguracoesTransmissao(new \StructType\TransmitirConfguracoesTransmissao()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirOperacao operation/method
 */
if ($transmitir->TransmitirOperacao(new \StructType\TransmitirOperacao()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirCerca operation/method
 */
if ($transmitir->TransmitirCerca(new \StructType\TransmitirCerca()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirRota operation/method
 */
if ($transmitir->TransmitirRota(new \StructType\TransmitirRota()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirParametrosVeiculo operation/method
 */
if ($transmitir->TransmitirParametrosVeiculo(new \StructType\TransmitirParametrosVeiculo()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirConfiguracoesUmidade operation/method
 */
if ($transmitir->TransmitirConfiguracoesUmidade(new \StructType\TransmitirConfiguracoesUmidade()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirCfgUmidade operation/method
 */
if ($transmitir->TransmitirCfgUmidade(new \StructType\TransmitirCfgUmidade()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirCfgMultiplosSensores operation/method
 */
if ($transmitir->TransmitirCfgMultiplosSensores(new \StructType\TransmitirCfgMultiplosSensores()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirConfiguracoesMultiplosSensores operation/method
 */
if ($transmitir->TransmitirConfiguracoesMultiplosSensores(new \StructType\TransmitirConfiguracoesMultiplosSensores()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirCfgTransmissao operation/method
 */
if ($transmitir->TransmitirCfgTransmissao(new \StructType\TransmitirCfgTransmissao()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Sample call for TransmitirConfiguracoesIbutton operation/method
 */
if ($transmitir->TransmitirConfiguracoesIbutton(new \StructType\TransmitirConfiguracoesIbutton()) !== false) {
    print_r($transmitir->getResult());
} else {
    print_r($transmitir->getLastError());
}
/**
 * Samples for Criar ServiceType
 */
$criar = new \ServiceType\Criar($options);
/**
 * Sample call for CriarPerfilAlvo operation/method
 */
if ($criar->CriarPerfilAlvo(new \StructType\CriarPerfilAlvo()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarConfiguracoesOpcoesSeguranca operation/method
 */
if ($criar->CriarConfiguracoesOpcoesSeguranca(new \StructType\CriarConfiguracoesOpcoesSeguranca()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarConfiguracoesConfiguracaoHistorico operation/method
 */
if ($criar->CriarConfiguracoesConfiguracaoHistorico(new \StructType\CriarConfiguracoesConfiguracaoHistorico()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarConfiguracoesExcecao operation/method
 */
if ($criar->CriarConfiguracoesExcecao(new \StructType\CriarConfiguracoesExcecao()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarConfiguracoesExcecaoXML operation/method
 */
if ($criar->CriarConfiguracoesExcecaoXML(new \StructType\CriarConfiguracoesExcecaoXML()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarConfiguracoesAtuadores operation/method
 */
if ($criar->CriarConfiguracoesAtuadores(new \StructType\CriarConfiguracoesAtuadores()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarConfiguracoesInterativo operation/method
 */
if ($criar->CriarConfiguracoesInterativo(new \StructType\CriarConfiguracoesInterativo()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarConfiguracoesSenhas operation/method
 */
if ($criar->CriarConfiguracoesSenhas(new \StructType\CriarConfiguracoesSenhas()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarConfiguracoesTemperatura operation/method
 */
if ($criar->CriarConfiguracoesTemperatura(new \StructType\CriarConfiguracoesTemperatura()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarConfiguracoesTransicao operation/method
 */
if ($criar->CriarConfiguracoesTransicao(new \StructType\CriarConfiguracoesTransicao()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarConfiguracoesOpcoesSe operation/method
 */
if ($criar->CriarConfiguracoesOpcoesSe(new \StructType\CriarConfiguracoesOpcoesSe()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarConfguracoesTransmissao operation/method
 */
if ($criar->CriarConfguracoesTransmissao(new \StructType\CriarConfguracoesTransmissao()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarPerfilCerca operation/method
 */
if ($criar->CriarPerfilCerca(new \StructType\CriarPerfilCerca()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarPerfilRota operation/method
 */
if ($criar->CriarPerfilRota(new \StructType\CriarPerfilRota()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarModTransicao operation/method
 */
if ($criar->CriarModTransicao(new \StructType\CriarModTransicao()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarConfiguracoesMultiplosSensores operation/method
 */
if ($criar->CriarConfiguracoesMultiplosSensores(new \StructType\CriarConfiguracoesMultiplosSensores()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarCfgMultiplosSensoresComNomePerfil operation/method
 */
if ($criar->CriarCfgMultiplosSensoresComNomePerfil(new \StructType\CriarCfgMultiplosSensoresComNomePerfil()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarConfiguracoesUmidade operation/method
 */
if ($criar->CriarConfiguracoesUmidade(new \StructType\CriarConfiguracoesUmidade()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarVeiculoSensor operation/method
 */
if ($criar->CriarVeiculoSensor(new \StructType\CriarVeiculoSensor()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarTesteComunicacao operation/method
 */
if ($criar->CriarTesteComunicacao(new \StructType\CriarTesteComunicacao()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarCfgIntervaloPosicaoAutomatica operation/method
 */
if ($criar->CriarCfgIntervaloPosicaoAutomatica(new \StructType\CriarCfgIntervaloPosicaoAutomatica()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarGrupoFuncaoProgramavel operation/method
 */
if ($criar->CriarGrupoFuncaoProgramavel(new \StructType\CriarGrupoFuncaoProgramavel()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarFuncaoProgramada operation/method
 */
if ($criar->CriarFuncaoProgramada(new \StructType\CriarFuncaoProgramada()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarRegra operation/method
 */
if ($criar->CriarRegra(new \StructType\CriarRegra()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Sample call for CriarSolicitacaoEspelhamentoReverso operation/method
 */
if ($criar->CriarSolicitacaoEspelhamentoReverso(new \StructType\CriarSolicitacaoEspelhamentoReverso()) !== false) {
    print_r($criar->getResult());
} else {
    print_r($criar->getLastError());
}
/**
 * Samples for Atualizar ServiceType
 */
$atualizar = new \ServiceType\Atualizar($options);
/**
 * Sample call for AtualizarPerfilAlvo operation/method
 */
if ($atualizar->AtualizarPerfilAlvo(new \StructType\AtualizarPerfilAlvo()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarConfiguracoesExcecaoXML operation/method
 */
if ($atualizar->AtualizarConfiguracoesExcecaoXML(new \StructType\AtualizarConfiguracoesExcecaoXML()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarConfiguracoesConfiguracaoHistorico operation/method
 */
if ($atualizar->AtualizarConfiguracoesConfiguracaoHistorico(new \StructType\AtualizarConfiguracoesConfiguracaoHistorico()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarConfiguracoesTransmissao operation/method
 */
if ($atualizar->AtualizarConfiguracoesTransmissao(new \StructType\AtualizarConfiguracoesTransmissao()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarConfiguracoesOpcoesSe operation/method
 */
if ($atualizar->AtualizarConfiguracoesOpcoesSe(new \StructType\AtualizarConfiguracoesOpcoesSe()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarConfiguracoesTransicao operation/method
 */
if ($atualizar->AtualizarConfiguracoesTransicao(new \StructType\AtualizarConfiguracoesTransicao()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarConfiguracoesTemperatura operation/method
 */
if ($atualizar->AtualizarConfiguracoesTemperatura(new \StructType\AtualizarConfiguracoesTemperatura()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarConfiguracoesInterativo operation/method
 */
if ($atualizar->AtualizarConfiguracoesInterativo(new \StructType\AtualizarConfiguracoesInterativo()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarConfiguracoesSenhas operation/method
 */
if ($atualizar->AtualizarConfiguracoesSenhas(new \StructType\AtualizarConfiguracoesSenhas()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarConfiguracoesAtuadores operation/method
 */
if ($atualizar->AtualizarConfiguracoesAtuadores(new \StructType\AtualizarConfiguracoesAtuadores()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarConfiguracoesOpcoesSeguranca operation/method
 */
if ($atualizar->AtualizarConfiguracoesOpcoesSeguranca(new \StructType\AtualizarConfiguracoesOpcoesSeguranca()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarConfiguracoesExcecao operation/method
 */
if ($atualizar->AtualizarConfiguracoesExcecao(new \StructType\AtualizarConfiguracoesExcecao()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarVeiculo operation/method
 */
if ($atualizar->AtualizarVeiculo(new \StructType\AtualizarVeiculo()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarVeiculoGestor operation/method
 */
if ($atualizar->AtualizarVeiculoGestor(new \StructType\AtualizarVeiculoGestor()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarModTransicao operation/method
 */
if ($atualizar->AtualizarModTransicao(new \StructType\AtualizarModTransicao()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarMensagemFormatada operation/method
 */
if ($atualizar->AtualizarMensagemFormatada(new \StructType\AtualizarMensagemFormatada()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarMensagemFormatadaItem operation/method
 */
if ($atualizar->AtualizarMensagemFormatadaItem(new \StructType\AtualizarMensagemFormatadaItem()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarConfiguracoesMultiplosSensores operation/method
 */
if ($atualizar->AtualizarConfiguracoesMultiplosSensores(new \StructType\AtualizarConfiguracoesMultiplosSensores()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarConfiguracoesUmidade operation/method
 */
if ($atualizar->AtualizarConfiguracoesUmidade(new \StructType\AtualizarConfiguracoesUmidade()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarPerfilCfg operation/method
 */
if ($atualizar->AtualizarPerfilCfg(new \StructType\AtualizarPerfilCfg()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarVeiculoSensor operation/method
 */
if ($atualizar->AtualizarVeiculoSensor(new \StructType\AtualizarVeiculoSensor()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarConfiguracaoAlertaComunicacao operation/method
 */
if ($atualizar->AtualizarConfiguracaoAlertaComunicacao(new \StructType\AtualizarConfiguracaoAlertaComunicacao()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarGrupoFuncaoProgramavel operation/method
 */
if ($atualizar->AtualizarGrupoFuncaoProgramavel(new \StructType\AtualizarGrupoFuncaoProgramavel()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarRegra operation/method
 */
if ($atualizar->AtualizarRegra(new \StructType\AtualizarRegra()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarFuncaoProgramada operation/method
 */
if ($atualizar->AtualizarFuncaoProgramada(new \StructType\AtualizarFuncaoProgramada()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Sample call for AtualizarMotivo operation/method
 */
if ($atualizar->AtualizarMotivo(new \StructType\AtualizarMotivo()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Samples for Lista ServiceType
 */
$lista = new \ServiceType\Lista($options);
/**
 * Sample call for ListaPerfis operation/method
 */
if ($lista->ListaPerfis(new \StructType\ListaPerfis()) !== false) {
    print_r($lista->getResult());
} else {
    print_r($lista->getLastError());
}
/**
 * Sample call for ListaPerfisCerca operation/method
 */
if ($lista->ListaPerfisCerca(new \StructType\ListaPerfisCerca()) !== false) {
    print_r($lista->getResult());
} else {
    print_r($lista->getLastError());
}
/**
 * Sample call for ListaPerfisRota operation/method
 */
if ($lista->ListaPerfisRota(new \StructType\ListaPerfisRota()) !== false) {
    print_r($lista->getResult());
} else {
    print_r($lista->getLastError());
}
/**
 * Samples for Operacao ServiceType
 */
$operacao = new \ServiceType\Operacao($options);
/**
 * Sample call for Operacao_Associar operation/method
 */
if ($operacao->Operacao_Associar(new \StructType\Operacao_Associar()) !== false) {
    print_r($operacao->getResult());
} else {
    print_r($operacao->getLastError());
}
/**
 * Sample call for Operacao_Transmitir operation/method
 */
if ($operacao->Operacao_Transmitir(new \StructType\Operacao_Transmitir()) !== false) {
    print_r($operacao->getResult());
} else {
    print_r($operacao->getLastError());
}
/**
 * Sample call for Operacao_SolicitaListaPerfilConfiguracao operation/method
 */
if ($operacao->Operacao_SolicitaListaPerfilConfiguracao(new \StructType\Operacao_SolicitaListaPerfilConfiguracao()) !== false) {
    print_r($operacao->getResult());
} else {
    print_r($operacao->getLastError());
}
/**
 * Sample call for Operacao_Associar_Perfil operation/method
 */
if ($operacao->Operacao_Associar_Perfil(new \StructType\Operacao_Associar_Perfil()) !== false) {
    print_r($operacao->getResult());
} else {
    print_r($operacao->getLastError());
}
/**
 * Sample call for Operacao_Transmitir_Perfil operation/method
 */
if ($operacao->Operacao_Transmitir_Perfil(new \StructType\Operacao_Transmitir_Perfil()) !== false) {
    print_r($operacao->getResult());
} else {
    print_r($operacao->getLastError());
}
/**
 * Sample call for OperacaoSolicitarStatus operation/method
 */
if ($operacao->OperacaoSolicitarStatus(new \StructType\OperacaoSolicitarStatus()) !== false) {
    print_r($operacao->getResult());
} else {
    print_r($operacao->getLastError());
}
/**
 * Sample call for Operacao_SolicitaListaOperacoes operation/method
 */
if ($operacao->Operacao_SolicitaListaOperacoes(new \StructType\Operacao_SolicitaListaOperacoes()) !== false) {
    print_r($operacao->getResult());
} else {
    print_r($operacao->getLastError());
}
/**
 * Samples for Cadastrar ServiceType
 */
$cadastrar = new \ServiceType\Cadastrar($options);
/**
 * Sample call for CadastrarPerfilConfiguracao operation/method
 */
if ($cadastrar->CadastrarPerfilConfiguracao(new \StructType\CadastrarPerfilConfiguracao()) !== false) {
    print_r($cadastrar->getResult());
} else {
    print_r($cadastrar->getLastError());
}
/**
 * Sample call for CadastrarOperacao operation/method
 */
if ($cadastrar->CadastrarOperacao(new \StructType\CadastrarOperacao()) !== false) {
    print_r($cadastrar->getResult());
} else {
    print_r($cadastrar->getLastError());
}
/**
 * Sample call for CadastrarItensOperacao operation/method
 */
if ($cadastrar->CadastrarItensOperacao(new \StructType\CadastrarItensOperacao()) !== false) {
    print_r($cadastrar->getResult());
} else {
    print_r($cadastrar->getLastError());
}
/**
 * Sample call for CadastrarTextoTerminal operation/method
 */
if ($cadastrar->CadastrarTextoTerminal(new \StructType\CadastrarTextoTerminal()) !== false) {
    print_r($cadastrar->getResult());
} else {
    print_r($cadastrar->getLastError());
}
/**
 * Sample call for CadastrarClasseDeReferencia operation/method
 */
if ($cadastrar->CadastrarClasseDeReferencia(new \StructType\CadastrarClasseDeReferencia()) !== false) {
    print_r($cadastrar->getResult());
} else {
    print_r($cadastrar->getLastError());
}
/**
 * Sample call for CadastrarPontoDeReferencia operation/method
 */
if ($cadastrar->CadastrarPontoDeReferencia(new \StructType\CadastrarPontoDeReferencia()) !== false) {
    print_r($cadastrar->getResult());
} else {
    print_r($cadastrar->getLastError());
}
/**
 * Sample call for CadastrarMotivo operation/method
 */
if ($cadastrar->CadastrarMotivo(new \StructType\CadastrarMotivo()) !== false) {
    print_r($cadastrar->getResult());
} else {
    print_r($cadastrar->getLastError());
}
/**
 * Sample call for CadastrarSensorDeAlarme operation/method
 */
if ($cadastrar->CadastrarSensorDeAlarme(new \StructType\CadastrarSensorDeAlarme()) !== false) {
    print_r($cadastrar->getResult());
} else {
    print_r($cadastrar->getLastError());
}
/**
 * Sample call for CadastrarSensorDeAlarmeDefault operation/method
 */
if ($cadastrar->CadastrarSensorDeAlarmeDefault(new \StructType\CadastrarSensorDeAlarmeDefault()) !== false) {
    print_r($cadastrar->getResult());
} else {
    print_r($cadastrar->getLastError());
}
/**
 * Samples for Transicoes ServiceType
 */
$transicoes = new \ServiceType\Transicoes($options);
/**
 * Sample call for Transicoes_InibirApagarFPs operation/method
 */
if ($transicoes->Transicoes_InibirApagarFPs(new \StructType\Transicoes_InibirApagarFPs()) !== false) {
    print_r($transicoes->getResult());
} else {
    print_r($transicoes->getLastError());
}
/**
 * Sample call for Transicoes_InibirFPs operation/method
 */
if ($transicoes->Transicoes_InibirFPs(new \StructType\Transicoes_InibirFPs()) !== false) {
    print_r($transicoes->getResult());
} else {
    print_r($transicoes->getLastError());
}
/**
 * Sample call for Transicoes_LiberarFPs operation/method
 */
if ($transicoes->Transicoes_LiberarFPs(new \StructType\Transicoes_LiberarFPs()) !== false) {
    print_r($transicoes->getResult());
} else {
    print_r($transicoes->getLastError());
}
/**
 * Sample call for Transicoes_SolicitaLista operation/method
 */
if ($transicoes->Transicoes_SolicitaLista(new \StructType\Transicoes_SolicitaLista()) !== false) {
    print_r($transicoes->getResult());
} else {
    print_r($transicoes->getLastError());
}
/**
 * Sample call for Transicoes_SolicitaListaTabelas operation/method
 */
if ($transicoes->Transicoes_SolicitaListaTabelas(new \StructType\Transicoes_SolicitaListaTabelas()) !== false) {
    print_r($transicoes->getResult());
} else {
    print_r($transicoes->getLastError());
}
/**
 * Sample call for Transicoes_SolicitaStatusEnvio operation/method
 */
if ($transicoes->Transicoes_SolicitaStatusEnvio(new \StructType\Transicoes_SolicitaStatusEnvio()) !== false) {
    print_r($transicoes->getResult());
} else {
    print_r($transicoes->getLastError());
}
/**
 * Sample call for Transicoes_EnviaConfiguracao operation/method
 */
if ($transicoes->Transicoes_EnviaConfiguracao(new \StructType\Transicoes_EnviaConfiguracao()) !== false) {
    print_r($transicoes->getResult());
} else {
    print_r($transicoes->getLastError());
}
/**
 * Samples for Importador ServiceType
 */
$importador = new \ServiceType\Importador($options);
/**
 * Sample call for ImportadorDeVeiculos operation/method
 */
if ($importador->ImportadorDeVeiculos(new \StructType\ImportadorDeVeiculos()) !== false) {
    print_r($importador->getResult());
} else {
    print_r($importador->getLastError());
}
/**
 * Sample call for ImportadorDePontoReferencia operation/method
 */
if ($importador->ImportadorDePontoReferencia(new \StructType\ImportadorDePontoReferencia()) !== false) {
    print_r($importador->getResult());
} else {
    print_r($importador->getLastError());
}
/**
 * Samples for Excluir ServiceType
 */
$excluir = new \ServiceType\Excluir($options);
/**
 * Sample call for ExcluirModTransicao operation/method
 */
if ($excluir->ExcluirModTransicao(new \StructType\ExcluirModTransicao()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirGrupoMensagemFormatada operation/method
 */
if ($excluir->ExcluirGrupoMensagemFormatada(new \StructType\ExcluirGrupoMensagemFormatada()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirMensagemFormatada operation/method
 */
if ($excluir->ExcluirMensagemFormatada(new \StructType\ExcluirMensagemFormatada()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirMensagemFormatadaItem operation/method
 */
if ($excluir->ExcluirMensagemFormatadaItem(new \StructType\ExcluirMensagemFormatadaItem()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirPerfilAlvo operation/method
 */
if ($excluir->ExcluirPerfilAlvo(new \StructType\ExcluirPerfilAlvo()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirPerfilRota operation/method
 */
if ($excluir->ExcluirPerfilRota(new \StructType\ExcluirPerfilRota()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirPerfilCerca operation/method
 */
if ($excluir->ExcluirPerfilCerca(new \StructType\ExcluirPerfilCerca()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirGrupoAlvo operation/method
 */
if ($excluir->ExcluirGrupoAlvo(new \StructType\ExcluirGrupoAlvo()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirGrupoRota operation/method
 */
if ($excluir->ExcluirGrupoRota(new \StructType\ExcluirGrupoRota()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirGrupoCerca operation/method
 */
if ($excluir->ExcluirGrupoCerca(new \StructType\ExcluirGrupoCerca()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirAssociacaoAlvo operation/method
 */
if ($excluir->ExcluirAssociacaoAlvo(new \StructType\ExcluirAssociacaoAlvo()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirAssociacaoRota operation/method
 */
if ($excluir->ExcluirAssociacaoRota(new \StructType\ExcluirAssociacaoRota()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirAssociacaoCerca operation/method
 */
if ($excluir->ExcluirAssociacaoCerca(new \StructType\ExcluirAssociacaoCerca()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirPerfilCfg operation/method
 */
if ($excluir->ExcluirPerfilCfg(new \StructType\ExcluirPerfilCfg()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirAlvoDeGrupo operation/method
 */
if ($excluir->ExcluirAlvoDeGrupo(new \StructType\ExcluirAlvoDeGrupo()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirRotaDeGrupo operation/method
 */
if ($excluir->ExcluirRotaDeGrupo(new \StructType\ExcluirRotaDeGrupo()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirCercaDeGrupo operation/method
 */
if ($excluir->ExcluirCercaDeGrupo(new \StructType\ExcluirCercaDeGrupo()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirVeiculoSensor operation/method
 */
if ($excluir->ExcluirVeiculoSensor(new \StructType\ExcluirVeiculoSensor()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirOperacao operation/method
 */
if ($excluir->ExcluirOperacao(new \StructType\ExcluirOperacao()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirOperacaoItem operation/method
 */
if ($excluir->ExcluirOperacaoItem(new \StructType\ExcluirOperacaoItem()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirGrupoFuncaoProgramavel operation/method
 */
if ($excluir->ExcluirGrupoFuncaoProgramavel(new \StructType\ExcluirGrupoFuncaoProgramavel()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirTextoTerminal operation/method
 */
if ($excluir->ExcluirTextoTerminal(new \StructType\ExcluirTextoTerminal()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirAssociacaoOperacaoEVeiculo operation/method
 */
if ($excluir->ExcluirAssociacaoOperacaoEVeiculo(new \StructType\ExcluirAssociacaoOperacaoEVeiculo()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirMotivo operation/method
 */
if ($excluir->ExcluirMotivo(new \StructType\ExcluirMotivo()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Sample call for ExcluirSolicitacaoEspelhamentoReverso operation/method
 */
if ($excluir->ExcluirSolicitacaoEspelhamentoReverso(new \StructType\ExcluirSolicitacaoEspelhamentoReverso()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Samples for Associar ServiceType
 */
$associar = new \ServiceType\Associar($options);
/**
 * Sample call for AssociarMensagemPredefinida operation/method
 */
if ($associar->AssociarMensagemPredefinida(new \StructType\AssociarMensagemPredefinida()) !== false) {
    print_r($associar->getResult());
} else {
    print_r($associar->getLastError());
}
/**
 * Sample call for AssociarMensagemFormatada operation/method
 */
if ($associar->AssociarMensagemFormatada(new \StructType\AssociarMensagemFormatada()) !== false) {
    print_r($associar->getResult());
} else {
    print_r($associar->getLastError());
}
/**
 * Sample call for AssociarMensagemPredefinidaXML operation/method
 */
if ($associar->AssociarMensagemPredefinidaXML(new \StructType\AssociarMensagemPredefinidaXML()) !== false) {
    print_r($associar->getResult());
} else {
    print_r($associar->getLastError());
}
/**
 * Sample call for AssociarMensagemFormatadaVeiculo operation/method
 */
if ($associar->AssociarMensagemFormatadaVeiculo(new \StructType\AssociarMensagemFormatadaVeiculo()) !== false) {
    print_r($associar->getResult());
} else {
    print_r($associar->getLastError());
}
/**
 * Sample call for AssociarMensagemFormatadaVeiculoXML operation/method
 */
if ($associar->AssociarMensagemFormatadaVeiculoXML(new \StructType\AssociarMensagemFormatadaVeiculoXML()) !== false) {
    print_r($associar->getResult());
} else {
    print_r($associar->getLastError());
}
/**
 * Sample call for AssociarMensagemPredefinidaTodos operation/method
 */
if ($associar->AssociarMensagemPredefinidaTodos(new \StructType\AssociarMensagemPredefinidaTodos()) !== false) {
    print_r($associar->getResult());
} else {
    print_r($associar->getLastError());
}
/**
 * Sample call for AssociarPerfilAlvosGrupo operation/method
 */
if ($associar->AssociarPerfilAlvosGrupo(new \StructType\AssociarPerfilAlvosGrupo()) !== false) {
    print_r($associar->getResult());
} else {
    print_r($associar->getLastError());
}
/**
 * Samples for Enviar ServiceType
 */
$enviar = new \ServiceType\Enviar($options);
/**
 * Sample call for EnviarMensagemPredefinida operation/method
 */
if ($enviar->EnviarMensagemPredefinida(new \StructType\EnviarMensagemPredefinida()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarMensagemPreMotorista operation/method
 */
if ($enviar->EnviarMensagemPreMotorista(new \StructType\EnviarMensagemPreMotorista()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarMensagemFormatada operation/method
 */
if ($enviar->EnviarMensagemFormatada(new \StructType\EnviarMensagemFormatada()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarComandoUmidadeAvulsa operation/method
 */
if ($enviar->EnviarComandoUmidadeAvulsa(new \StructType\EnviarComandoUmidadeAvulsa()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarCfgIbuttonAntifurto operation/method
 */
if ($enviar->EnviarCfgIbuttonAntifurto(new \StructType\EnviarCfgIbuttonAntifurto()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarComandoIbuttonHabilitaIdentificacao operation/method
 */
if ($enviar->EnviarComandoIbuttonHabilitaIdentificacao(new \StructType\EnviarComandoIbuttonHabilitaIdentificacao()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarComandoIbuttonConfiguraLiberacaoMotorista operation/method
 */
if ($enviar->EnviarComandoIbuttonConfiguraLiberacaoMotorista(new \StructType\EnviarComandoIbuttonConfiguraLiberacaoMotorista()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarComandoIbuttonConfiguraAcaoFalhaIdentificacao
 * operation/method
 */
if ($enviar->EnviarComandoIbuttonConfiguraAcaoFalhaIdentificacao(new \StructType\EnviarComandoIbuttonConfiguraAcaoFalhaIdentificacao()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarComandoIbuttonValidaListaIbuttons operation/method
 */
if ($enviar->EnviarComandoIbuttonValidaListaIbuttons(new \StructType\EnviarComandoIbuttonValidaListaIbuttons()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarComandoIbuttonHabilitaPartida operation/method
 */
if ($enviar->EnviarComandoIbuttonHabilitaPartida(new \StructType\EnviarComandoIbuttonHabilitaPartida()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarConfigOmniTelemetria operation/method
 */
if ($enviar->EnviarConfigOmniTelemetria(new \StructType\EnviarConfigOmniTelemetria()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarConfigFlagTrasmissaoDeEventos operation/method
 */
if ($enviar->EnviarConfigFlagTrasmissaoDeEventos(new \StructType\EnviarConfigFlagTrasmissaoDeEventos()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarLoteConfigFlagTrasmissaoDeEventos operation/method
 */
if ($enviar->EnviarLoteConfigFlagTrasmissaoDeEventos(new \StructType\EnviarLoteConfigFlagTrasmissaoDeEventos()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Samples for Novo ServiceType
 */
$novo = new \ServiceType\Novo($options);
/**
 * Sample call for NovoGrupoMensagemFormatada operation/method
 */
if ($novo->NovoGrupoMensagemFormatada(new \StructType\NovoGrupoMensagemFormatada()) !== false) {
    print_r($novo->getResult());
} else {
    print_r($novo->getLastError());
}
/**
 * Sample call for NovoMensagemFormatada operation/method
 */
if ($novo->NovoMensagemFormatada(new \StructType\NovoMensagemFormatada()) !== false) {
    print_r($novo->getResult());
} else {
    print_r($novo->getLastError());
}
/**
 * Sample call for NovoMensagemFormatadaXMLItens operation/method
 */
if ($novo->NovoMensagemFormatadaXMLItens(new \StructType\NovoMensagemFormatadaXMLItens()) !== false) {
    print_r($novo->getResult());
} else {
    print_r($novo->getLastError());
}
/**
 * Sample call for NovoMensagemFormatadaItem operation/method
 */
if ($novo->NovoMensagemFormatadaItem(new \StructType\NovoMensagemFormatadaItem()) !== false) {
    print_r($novo->getResult());
} else {
    print_r($novo->getLastError());
}
/**
 * Sample call for NovoParametroVeiculo operation/method
 */
if ($novo->NovoParametroVeiculo(new \StructType\NovoParametroVeiculo()) !== false) {
    print_r($novo->getResult());
} else {
    print_r($novo->getLastError());
}
/**
 * Sample call for NovoPerfilParametroVeiculo operation/method
 */
if ($novo->NovoPerfilParametroVeiculo(new \StructType\NovoPerfilParametroVeiculo()) !== false) {
    print_r($novo->getResult());
} else {
    print_r($novo->getLastError());
}
/**
 * Samples for Verifica ServiceType
 */
$verifica = new \ServiceType\Verifica($options);
/**
 * Sample call for VerificaFuncaoProgramadaHabilitado operation/method
 */
if ($verifica->VerificaFuncaoProgramadaHabilitado(new \StructType\VerificaFuncaoProgramadaHabilitado()) !== false) {
    print_r($verifica->getResult());
} else {
    print_r($verifica->getLastError());
}
/**
 * Samples for Desassociar ServiceType
 */
$desassociar = new \ServiceType\Desassociar($options);
/**
 * Sample call for DesassociarMensagemFormatadaVeiculo operation/method
 */
if ($desassociar->DesassociarMensagemFormatadaVeiculo(new \StructType\DesassociarMensagemFormatadaVeiculo()) !== false) {
    print_r($desassociar->getResult());
} else {
    print_r($desassociar->getLastError());
}
/**
 * Sample call for DesassociarMensagemFormatadaVeiculoXML operation/method
 */
if ($desassociar->DesassociarMensagemFormatadaVeiculoXML(new \StructType\DesassociarMensagemFormatadaVeiculoXML()) !== false) {
    print_r($desassociar->getResult());
} else {
    print_r($desassociar->getLastError());
}
/**
 * Sample call for DesassociarCercasDeVeiculos operation/method
 */
if ($desassociar->DesassociarCercasDeVeiculos(new \StructType\DesassociarCercasDeVeiculos()) !== false) {
    print_r($desassociar->getResult());
} else {
    print_r($desassociar->getLastError());
}
/**
 * Sample call for DesassociarAlvosDeVeiculos operation/method
 */
if ($desassociar->DesassociarAlvosDeVeiculos(new \StructType\DesassociarAlvosDeVeiculos()) !== false) {
    print_r($desassociar->getResult());
} else {
    print_r($desassociar->getLastError());
}
/**
 * Sample call for DesassociarRotasDeVeiculos operation/method
 */
if ($desassociar->DesassociarRotasDeVeiculos(new \StructType\DesassociarRotasDeVeiculos()) !== false) {
    print_r($desassociar->getResult());
} else {
    print_r($desassociar->getLastError());
}
/**
 * Samples for Ultima ServiceType
 */
$ultima = new \ServiceType\Ultima($options);
/**
 * Sample call for UltimaMensagemFormatadaEnviadaVeiculo operation/method
 */
if ($ultima->UltimaMensagemFormatadaEnviadaVeiculo(new \StructType\UltimaMensagemFormatadaEnviadaVeiculo()) !== false) {
    print_r($ultima->getResult());
} else {
    print_r($ultima->getLastError());
}
/**
 * Sample call for UltimaGrupoAlvoEnviadaVeiculo operation/method
 */
if ($ultima->UltimaGrupoAlvoEnviadaVeiculo(new \StructType\UltimaGrupoAlvoEnviadaVeiculo()) !== false) {
    print_r($ultima->getResult());
} else {
    print_r($ultima->getLastError());
}
/**
 * Sample call for UltimaGrupoCercaEnviadaVeiculo operation/method
 */
if ($ultima->UltimaGrupoCercaEnviadaVeiculo(new \StructType\UltimaGrupoCercaEnviadaVeiculo()) !== false) {
    print_r($ultima->getResult());
} else {
    print_r($ultima->getLastError());
}
/**
 * Sample call for UltimaGrupoRotaEnviadaVeiculo operation/method
 */
if ($ultima->UltimaGrupoRotaEnviadaVeiculo(new \StructType\UltimaGrupoRotaEnviadaVeiculo()) !== false) {
    print_r($ultima->getResult());
} else {
    print_r($ultima->getLastError());
}
/**
 * Sample call for UltimaMensagemPredefinidaEnviadaVeiculo operation/method
 */
if ($ultima->UltimaMensagemPredefinidaEnviadaVeiculo(new \StructType\UltimaMensagemPredefinidaEnviadaVeiculo()) !== false) {
    print_r($ultima->getResult());
} else {
    print_r($ultima->getLastError());
}
/**
 * Samples for Versao ServiceType
 */
$versao = new \ServiceType\Versao($options);
/**
 * Sample call for VersaoWstt operation/method
 */
if ($versao->VersaoWstt(new \StructType\VersaoWstt()) !== false) {
    print_r($versao->getResult());
} else {
    print_r($versao->getLastError());
}
/**
 * Samples for Ficha ServiceType
 */
$ficha = new \ServiceType\Ficha($options);
/**
 * Sample call for FichaAtivacao operation/method
 */
if ($ficha->FichaAtivacao(new \StructType\FichaAtivacao()) !== false) {
    print_r($ficha->getResult());
} else {
    print_r($ficha->getLastError());
}
/**
 * Samples for Comando ServiceType
 */
$comando = new \ServiceType\Comando($options);
/**
 * Sample call for ComandoLiberar5Roda operation/method
 */
if ($comando->ComandoLiberar5Roda(new \StructType\ComandoLiberar5Roda()) !== false) {
    print_r($comando->getResult());
} else {
    print_r($comando->getLastError());
}
/**
 * Sample call for ComandoIscaIniciarEmergencia operation/method
 */
if ($comando->ComandoIscaIniciarEmergencia(new \StructType\ComandoIscaIniciarEmergencia()) !== false) {
    print_r($comando->getResult());
} else {
    print_r($comando->getLastError());
}
/**
 * Sample call for ComandoIscaPararEmergencia operation/method
 */
if ($comando->ComandoIscaPararEmergencia(new \StructType\ComandoIscaPararEmergencia()) !== false) {
    print_r($comando->getResult());
} else {
    print_r($comando->getLastError());
}
/**
 * Sample call for ComandoIscaCCID operation/method
 */
if ($comando->ComandoIscaCCID(new \StructType\ComandoIscaCCID()) !== false) {
    print_r($comando->getResult());
} else {
    print_r($comando->getLastError());
}
/**
 * Sample call for ComandoIscaPreset operation/method
 */
if ($comando->ComandoIscaPreset(new \StructType\ComandoIscaPreset()) !== false) {
    print_r($comando->getResult());
} else {
    print_r($comando->getLastError());
}
/**
 * Sample call for ComandoIscaConfigTempos operation/method
 */
if ($comando->ComandoIscaConfigTempos(new \StructType\ComandoIscaConfigTempos()) !== false) {
    print_r($comando->getResult());
} else {
    print_r($comando->getLastError());
}
/**
 * Samples for Retornar ServiceType
 */
$retornar = new \ServiceType\Retornar($options);
/**
 * Sample call for RetornarInformacoesGrupoFuncaoProgramavel operation/method
 */
if ($retornar->RetornarInformacoesGrupoFuncaoProgramavel(new \StructType\RetornarInformacoesGrupoFuncaoProgramavel()) !== false) {
    print_r($retornar->getResult());
} else {
    print_r($retornar->getLastError());
}
/**
 * Samples for Editar ServiceType
 */
$editar = new \ServiceType\Editar($options);
/**
 * Sample call for EditarTextoTerminal operation/method
 */
if ($editar->EditarTextoTerminal(new \StructType\EditarTextoTerminal()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarVariavelPersonalizada operation/method
 */
if ($editar->EditarVariavelPersonalizada(new \StructType\EditarVariavelPersonalizada()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarClasseDeReferencia operation/method
 */
if ($editar->EditarClasseDeReferencia(new \StructType\EditarClasseDeReferencia()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarPontoDeReferencia operation/method
 */
if ($editar->EditarPontoDeReferencia(new \StructType\EditarPontoDeReferencia()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarPerfilCerca operation/method
 */
if ($editar->EditarPerfilCerca(new \StructType\EditarPerfilCerca()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarPerfilRota operation/method
 */
if ($editar->EditarPerfilRota(new \StructType\EditarPerfilRota()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarOperacao operation/method
 */
if ($editar->EditarOperacao(new \StructType\EditarOperacao()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarSensorDeAlarme operation/method
 */
if ($editar->EditarSensorDeAlarme(new \StructType\EditarSensorDeAlarme()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Samples for Gera ServiceType
 */
$gera = new \ServiceType\Gera($options);
/**
 * Sample call for GeraSenhaDesbloqueio operation/method
 */
if ($gera->GeraSenhaDesbloqueio(new \StructType\GeraSenhaDesbloqueio()) !== false) {
    print_r($gera->getResult());
} else {
    print_r($gera->getLastError());
}
/**
 * Sample call for GeraSenhaAutorizacao operation/method
 */
if ($gera->GeraSenhaAutorizacao(new \StructType\GeraSenhaAutorizacao()) !== false) {
    print_r($gera->getResult());
} else {
    print_r($gera->getLastError());
}
/**
 * Samples for Remover ServiceType
 */
$remover = new \ServiceType\Remover($options);
/**
 * Sample call for RemoverClasseDeReferencia operation/method
 */
if ($remover->RemoverClasseDeReferencia(new \StructType\RemoverClasseDeReferencia()) !== false) {
    print_r($remover->getResult());
} else {
    print_r($remover->getLastError());
}
/**
 * Sample call for RemoverPontoDeReferencia operation/method
 */
if ($remover->RemoverPontoDeReferencia(new \StructType\RemoverPontoDeReferencia()) !== false) {
    print_r($remover->getResult());
} else {
    print_r($remover->getLastError());
}
/**
 * Sample call for RemoverCfgExcecao operation/method
 */
if ($remover->RemoverCfgExcecao(new \StructType\RemoverCfgExcecao()) !== false) {
    print_r($remover->getResult());
} else {
    print_r($remover->getLastError());
}
/**
 * Sample call for RemoverCfgOpcoesSE operation/method
 */
if ($remover->RemoverCfgOpcoesSE(new \StructType\RemoverCfgOpcoesSE()) !== false) {
    print_r($remover->getResult());
} else {
    print_r($remover->getLastError());
}
/**
 * Sample call for RemoverSensorDeAlarme operation/method
 */
if ($remover->RemoverSensorDeAlarme(new \StructType\RemoverSensorDeAlarme()) !== false) {
    print_r($remover->getResult());
} else {
    print_r($remover->getLastError());
}
/**
 * Sample call for RemoverCfgTransmissao operation/method
 */
if ($remover->RemoverCfgTransmissao(new \StructType\RemoverCfgTransmissao()) !== false) {
    print_r($remover->getResult());
} else {
    print_r($remover->getLastError());
}
/**
 * Sample call for RemoverCfgOpcoesSeg operation/method
 */
if ($remover->RemoverCfgOpcoesSeg(new \StructType\RemoverCfgOpcoesSeg()) !== false) {
    print_r($remover->getResult());
} else {
    print_r($remover->getLastError());
}
/**
 * Sample call for RemoverCfgInterativo operation/method
 */
if ($remover->RemoverCfgInterativo(new \StructType\RemoverCfgInterativo()) !== false) {
    print_r($remover->getResult());
} else {
    print_r($remover->getLastError());
}
/**
 * Sample call for RemoverCfgAtuadores operation/method
 */
if ($remover->RemoverCfgAtuadores(new \StructType\RemoverCfgAtuadores()) !== false) {
    print_r($remover->getResult());
} else {
    print_r($remover->getLastError());
}
/**
 * Sample call for RemoverCfgSenhas operation/method
 */
if ($remover->RemoverCfgSenhas(new \StructType\RemoverCfgSenhas()) !== false) {
    print_r($remover->getResult());
} else {
    print_r($remover->getLastError());
}
/**
 * Sample call for RemoverCfgHistorico operation/method
 */
if ($remover->RemoverCfgHistorico(new \StructType\RemoverCfgHistorico()) !== false) {
    print_r($remover->getResult());
} else {
    print_r($remover->getLastError());
}
/**
 * Sample call for RemoverCfgTemperatura operation/method
 */
if ($remover->RemoverCfgTemperatura(new \StructType\RemoverCfgTemperatura()) !== false) {
    print_r($remover->getResult());
} else {
    print_r($remover->getLastError());
}
/**
 * Sample call for RemoverCfgUmidade operation/method
 */
if ($remover->RemoverCfgUmidade(new \StructType\RemoverCfgUmidade()) !== false) {
    print_r($remover->getResult());
} else {
    print_r($remover->getLastError());
}
/**
 * Sample call for RemoverCfgMultiplosSensores operation/method
 */
if ($remover->RemoverCfgMultiplosSensores(new \StructType\RemoverCfgMultiplosSensores()) !== false) {
    print_r($remover->getResult());
} else {
    print_r($remover->getLastError());
}
/**
 * Samples for Recuperar ServiceType
 */
$recuperar = new \ServiceType\Recuperar($options);
/**
 * Sample call for RecuperarDadosPontoDeReferencia operation/method
 */
if ($recuperar->RecuperarDadosPontoDeReferencia(new \StructType\RecuperarDadosPontoDeReferencia()) !== false) {
    print_r($recuperar->getResult());
} else {
    print_r($recuperar->getLastError());
}
/**
 * Samples for Salvar ServiceType
 */
$salvar = new \ServiceType\Salvar($options);
/**
 * Sample call for SalvarAlertasAlteradosByCliente operation/method
 */
if ($salvar->SalvarAlertasAlteradosByCliente(new \StructType\SalvarAlertasAlteradosByCliente()) !== false) {
    print_r($salvar->getResult());
} else {
    print_r($salvar->getLastError());
}
/**
 * Sample call for SalvarPosicaoViaOcorrencia operation/method
 */
if ($salvar->SalvarPosicaoViaOcorrencia(new \StructType\SalvarPosicaoViaOcorrencia()) !== false) {
    print_r($salvar->getResult());
} else {
    print_r($salvar->getLastError());
}
/**
 * Samples for Gerar ServiceType
 */
$gerar = new \ServiceType\Gerar($options);
/**
 * Sample call for GerarRelatorioDeCoordenadas operation/method
 */
if ($gerar->GerarRelatorioDeCoordenadas(new \StructType\GerarRelatorioDeCoordenadas()) !== false) {
    print_r($gerar->getResult());
} else {
    print_r($gerar->getLastError());
}
/**
 * Samples for Alterar ServiceType
 */
$alterar = new \ServiceType\Alterar($options);
/**
 * Sample call for AlterarIntervaloPosicao operation/method
 */
if ($alterar->AlterarIntervaloPosicao(new \StructType\AlterarIntervaloPosicao()) !== false) {
    print_r($alterar->getResult());
} else {
    print_r($alterar->getLastError());
}
/**
 * Sample call for AlterarIntervaloSateliteTemporario operation/method
 */
if ($alterar->AlterarIntervaloSateliteTemporario(new \StructType\AlterarIntervaloSateliteTemporario()) !== false) {
    print_r($alterar->getResult());
} else {
    print_r($alterar->getLastError());
}
/**
 * Samples for Acordar ServiceType
 */
$acordar = new \ServiceType\Acordar($options);
/**
 * Sample call for AcordarRastreador operation/method
 */
if ($acordar->AcordarRastreador(new \StructType\AcordarRastreador()) !== false) {
    print_r($acordar->getResult());
} else {
    print_r($acordar->getLastError());
}
/**
 * Samples for Detalhar ServiceType
 */
$detalhar = new \ServiceType\Detalhar($options);
/**
 * Sample call for DetalharVeiculo operation/method
 */
if ($detalhar->DetalharVeiculo(new \StructType\DetalharVeiculo()) !== false) {
    print_r($detalhar->getResult());
} else {
    print_r($detalhar->getLastError());
}
/**
 * Samples for Mudar ServiceType
 */
$mudar = new \ServiceType\Mudar($options);
/**
 * Sample call for MudarGrupoDoAlvo operation/method
 */
if ($mudar->MudarGrupoDoAlvo(new \StructType\MudarGrupoDoAlvo()) !== false) {
    print_r($mudar->getResult());
} else {
    print_r($mudar->getLastError());
}
/**
 * Sample call for MudarGrupoDaRota operation/method
 */
if ($mudar->MudarGrupoDaRota(new \StructType\MudarGrupoDaRota()) !== false) {
    print_r($mudar->getResult());
} else {
    print_r($mudar->getLastError());
}
/**
 * Sample call for MudarGrupoDaCerca operation/method
 */
if ($mudar->MudarGrupoDaCerca(new \StructType\MudarGrupoDaCerca()) !== false) {
    print_r($mudar->getResult());
} else {
    print_r($mudar->getLastError());
}
/**
 * Samples for Aceite ServiceType
 */
$aceite = new \ServiceType\Aceite($options);
/**
 * Sample call for AceiteDeEspelhamentoReverso operation/method
 */
if ($aceite->AceiteDeEspelhamentoReverso(new \StructType\AceiteDeEspelhamentoReverso()) !== false) {
    print_r($aceite->getResult());
} else {
    print_r($aceite->getLastError());
}
/**
 * Samples for Ordenar ServiceType
 */
$ordenar = new \ServiceType\Ordenar($options);
/**
 * Sample call for OrdenarAlvosAssociados operation/method
 */
if ($ordenar->OrdenarAlvosAssociados(new \StructType\OrdenarAlvosAssociados()) !== false) {
    print_r($ordenar->getResult());
} else {
    print_r($ordenar->getLastError());
}
/**
 * Samples for Posicao ServiceType
 */
$posicao = new \ServiceType\Posicao($options);
/**
 * Sample call for PosicaoViaOcorrencia operation/method
 */
if ($posicao->PosicaoViaOcorrencia(new \StructType\PosicaoViaOcorrencia()) !== false) {
    print_r($posicao->getResult());
} else {
    print_r($posicao->getLastError());
}
/**
 * Samples for Limpar ServiceType
 */
$limpar = new \ServiceType\Limpar($options);
/**
 * Sample call for LimparCercasRastreador operation/method
 */
if ($limpar->LimparCercasRastreador(new \StructType\LimparCercasRastreador()) !== false) {
    print_r($limpar->getResult());
} else {
    print_r($limpar->getLastError());
}
/**
 * Sample call for LimparAlvosRastreador operation/method
 */
if ($limpar->LimparAlvosRastreador(new \StructType\LimparAlvosRastreador()) !== false) {
    print_r($limpar->getResult());
} else {
    print_r($limpar->getLastError());
}
/**
 * Sample call for LimparRotasRastreador operation/method
 */
if ($limpar->LimparRotasRastreador(new \StructType\LimparRotasRastreador()) !== false) {
    print_r($limpar->getResult());
} else {
    print_r($limpar->getLastError());
}
/**
 * Sample call for LimparMensagemFormatada operation/method
 */
if ($limpar->LimparMensagemFormatada(new \StructType\LimparMensagemFormatada()) !== false) {
    print_r($limpar->getResult());
} else {
    print_r($limpar->getLastError());
}
/**
 * Samples for Exibir ServiceType
 */
$exibir = new \ServiceType\Exibir($options);
/**
 * Sample call for ExibirVersaoFirmwareHardware operation/method
 */
if ($exibir->ExibirVersaoFirmwareHardware(new \StructType\ExibirVersaoFirmwareHardware()) !== false) {
    print_r($exibir->getResult());
} else {
    print_r($exibir->getLastError());
}
/**
 * Samples for Cancelar ServiceType
 */
$cancelar = new \ServiceType\Cancelar($options);
/**
 * Sample call for CancelarComando operation/method
 */
if ($cancelar->CancelarComando(new \StructType\CancelarComando()) !== false) {
    print_r($cancelar->getResult());
} else {
    print_r($cancelar->getLastError());
}
