<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MensagemLivre StructType
 * Meta information extracted from the WSDL
 * - type: tns:MensagemLivre
 * @subpackage Structs
 */
class MensagemLivre extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The idVeiculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $idVeiculo;
    /**
     * The Mensagem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Mensagem;
    /**
     * The idMensagem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idMensagem;
    /**
     * The ConfirmaLeitura
     * @var bool
     */
    public $ConfirmaLeitura;
    /**
     * Constructor method for MensagemLivre
     * @uses MensagemLivre::setUsuario()
     * @uses MensagemLivre::setSenha()
     * @uses MensagemLivre::setIdVeiculo()
     * @uses MensagemLivre::setMensagem()
     * @uses MensagemLivre::setIdMensagem()
     * @uses MensagemLivre::setConfirmaLeitura()
     * @param string $usuario
     * @param string $senha
     * @param string $idVeiculo
     * @param string $mensagem
     * @param int $idMensagem
     * @param bool $confirmaLeitura
     */
    public function __construct($usuario = null, $senha = null, $idVeiculo = null, $mensagem = null, $idMensagem = null, $confirmaLeitura = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdVeiculo($idVeiculo)
            ->setMensagem($mensagem)
            ->setIdMensagem($idMensagem)
            ->setConfirmaLeitura($confirmaLeitura);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\MensagemLivre
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\MensagemLivre
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get idVeiculo value
     * @return string|null
     */
    public function getIdVeiculo()
    {
        return $this->idVeiculo;
    }
    /**
     * Set idVeiculo value
     * @param string $idVeiculo
     * @return \StructType\MensagemLivre
     */
    public function setIdVeiculo($idVeiculo = null)
    {
        // validation for constraint: string
        if (!is_null($idVeiculo) && !is_string($idVeiculo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idVeiculo, true), gettype($idVeiculo)), __LINE__);
        }
        $this->idVeiculo = $idVeiculo;
        return $this;
    }
    /**
     * Get Mensagem value
     * @return string|null
     */
    public function getMensagem()
    {
        return $this->Mensagem;
    }
    /**
     * Set Mensagem value
     * @param string $mensagem
     * @return \StructType\MensagemLivre
     */
    public function setMensagem($mensagem = null)
    {
        // validation for constraint: string
        if (!is_null($mensagem) && !is_string($mensagem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mensagem, true), gettype($mensagem)), __LINE__);
        }
        $this->Mensagem = $mensagem;
        return $this;
    }
    /**
     * Get idMensagem value
     * @return int|null
     */
    public function getIdMensagem()
    {
        return $this->idMensagem;
    }
    /**
     * Set idMensagem value
     * @param int $idMensagem
     * @return \StructType\MensagemLivre
     */
    public function setIdMensagem($idMensagem = null)
    {
        // validation for constraint: int
        if (!is_null($idMensagem) && !(is_int($idMensagem) || ctype_digit($idMensagem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idMensagem, true), gettype($idMensagem)), __LINE__);
        }
        $this->idMensagem = $idMensagem;
        return $this;
    }
    /**
     * Get ConfirmaLeitura value
     * @return bool|null
     */
    public function getConfirmaLeitura()
    {
        return $this->ConfirmaLeitura;
    }
    /**
     * Set ConfirmaLeitura value
     * @param bool $confirmaLeitura
     * @return \StructType\MensagemLivre
     */
    public function setConfirmaLeitura($confirmaLeitura = null)
    {
        // validation for constraint: boolean
        if (!is_null($confirmaLeitura) && !is_bool($confirmaLeitura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($confirmaLeitura, true), gettype($confirmaLeitura)), __LINE__);
        }
        $this->ConfirmaLeitura = $confirmaLeitura;
        return $this;
    }
}
