<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcluirPerfilCfg StructType
 * Meta information extracted from the WSDL
 * - type: tns:ExcluirPerfilCfg
 * @subpackage Structs
 */
class ExcluirPerfilCfg extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The idPerfil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idPerfil;
    /**
     * Constructor method for ExcluirPerfilCfg
     * @uses ExcluirPerfilCfg::setUsuario()
     * @uses ExcluirPerfilCfg::setSenha()
     * @uses ExcluirPerfilCfg::setIdPerfil()
     * @param string $usuario
     * @param string $senha
     * @param int $idPerfil
     */
    public function __construct($usuario = null, $senha = null, $idPerfil = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdPerfil($idPerfil);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ExcluirPerfilCfg
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ExcluirPerfilCfg
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get idPerfil value
     * @return int|null
     */
    public function getIdPerfil()
    {
        return $this->idPerfil;
    }
    /**
     * Set idPerfil value
     * @param int $idPerfil
     * @return \StructType\ExcluirPerfilCfg
     */
    public function setIdPerfil($idPerfil = null)
    {
        // validation for constraint: int
        if (!is_null($idPerfil) && !(is_int($idPerfil) || ctype_digit($idPerfil))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idPerfil, true), gettype($idPerfil)), __LINE__);
        }
        $this->idPerfil = $idPerfil;
        return $this;
    }
}
