<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcluirPerfilCerca StructType
 * Meta information extracted from the WSDL
 * - type: tns:ExcluirPerfilCerca
 * @subpackage Structs
 */
class ExcluirPerfilCerca extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The idPerfilCerca
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idPerfilCerca;
    /**
     * Constructor method for ExcluirPerfilCerca
     * @uses ExcluirPerfilCerca::setUsuario()
     * @uses ExcluirPerfilCerca::setSenha()
     * @uses ExcluirPerfilCerca::setIdPerfilCerca()
     * @param string $usuario
     * @param string $senha
     * @param int $idPerfilCerca
     */
    public function __construct($usuario = null, $senha = null, $idPerfilCerca = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdPerfilCerca($idPerfilCerca);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ExcluirPerfilCerca
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ExcluirPerfilCerca
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get idPerfilCerca value
     * @return int|null
     */
    public function getIdPerfilCerca()
    {
        return $this->idPerfilCerca;
    }
    /**
     * Set idPerfilCerca value
     * @param int $idPerfilCerca
     * @return \StructType\ExcluirPerfilCerca
     */
    public function setIdPerfilCerca($idPerfilCerca = null)
    {
        // validation for constraint: int
        if (!is_null($idPerfilCerca) && !(is_int($idPerfilCerca) || ctype_digit($idPerfilCerca))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idPerfilCerca, true), gettype($idPerfilCerca)), __LINE__);
        }
        $this->idPerfilCerca = $idPerfilCerca;
        return $this;
    }
}
