<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcluirGrupoAlvo StructType
 * Meta information extracted from the WSDL
 * - type: tns:ExcluirGrupoAlvo
 * @subpackage Structs
 */
class ExcluirGrupoAlvo extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The idGrupoAlvo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idGrupoAlvo;
    /**
     * Constructor method for ExcluirGrupoAlvo
     * @uses ExcluirGrupoAlvo::setUsuario()
     * @uses ExcluirGrupoAlvo::setSenha()
     * @uses ExcluirGrupoAlvo::setIdGrupoAlvo()
     * @param string $usuario
     * @param string $senha
     * @param int $idGrupoAlvo
     */
    public function __construct($usuario = null, $senha = null, $idGrupoAlvo = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdGrupoAlvo($idGrupoAlvo);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ExcluirGrupoAlvo
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ExcluirGrupoAlvo
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get idGrupoAlvo value
     * @return int|null
     */
    public function getIdGrupoAlvo()
    {
        return $this->idGrupoAlvo;
    }
    /**
     * Set idGrupoAlvo value
     * @param int $idGrupoAlvo
     * @return \StructType\ExcluirGrupoAlvo
     */
    public function setIdGrupoAlvo($idGrupoAlvo = null)
    {
        // validation for constraint: int
        if (!is_null($idGrupoAlvo) && !(is_int($idGrupoAlvo) || ctype_digit($idGrupoAlvo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idGrupoAlvo, true), gettype($idGrupoAlvo)), __LINE__);
        }
        $this->idGrupoAlvo = $idGrupoAlvo;
        return $this;
    }
}
