<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lacrar ServiceType
 * @subpackage Services
 */
class Lacrar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LacrarBau
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LacrarBau $parameters
     * @return \StructType\LacrarBauResponse|bool
     */
    public function LacrarBau(\StructType\LacrarBau $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LacrarBau($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LacrarCabine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LacrarCabine $parameters
     * @return \StructType\LacrarCabineResponse|bool
     */
    public function LacrarCabine(\StructType\LacrarCabine $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LacrarCabine($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LacrarCarreta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LacrarCarreta $parameters
     * @return \StructType\LacrarCarretaResponse|bool
     */
    public function LacrarCarreta(\StructType\LacrarCarreta $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LacrarCarreta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LacrarMotor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LacrarMotor $parameters
     * @return \StructType\LacrarMotorResponse|bool
     */
    public function LacrarMotor(\StructType\LacrarMotor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LacrarMotor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LacrarBauResponse|\StructType\LacrarCabineResponse|\StructType\LacrarCarretaResponse|\StructType\LacrarMotorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
