<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Importador ServiceType
 * @subpackage Services
 */
class Importador extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ImportadorDeVeiculos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportadorDeVeiculos $parameters
     * @return \StructType\ImportadorDeVeiculosResponse|bool
     */
    public function ImportadorDeVeiculos(\StructType\ImportadorDeVeiculos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportadorDeVeiculos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportadorDePontoReferencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportadorDePontoReferencia $parameters
     * @return \StructType\ImportadorDePontoReferenciaResponse|bool
     */
    public function ImportadorDePontoReferencia(\StructType\ImportadorDePontoReferencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportadorDePontoReferencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ImportadorDePontoReferenciaResponse|\StructType\ImportadorDeVeiculosResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
