<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Comando ServiceType
 * @subpackage Services
 */
class Comando extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ComandoLiberar5Roda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ComandoLiberar5Roda $parameters
     * @return \StructType\ComandoLiberar5RodaResponse|bool
     */
    public function ComandoLiberar5Roda(\StructType\ComandoLiberar5Roda $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ComandoLiberar5Roda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ComandoIscaIniciarEmergencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ComandoIscaIniciarEmergencia $parameters
     * @return \StructType\ComandoIscaIniciarEmergenciaResponse|bool
     */
    public function ComandoIscaIniciarEmergencia(\StructType\ComandoIscaIniciarEmergencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ComandoIscaIniciarEmergencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ComandoIscaPararEmergencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ComandoIscaPararEmergencia $parameters
     * @return \StructType\ComandoIscaPararEmergenciaResponse|bool
     */
    public function ComandoIscaPararEmergencia(\StructType\ComandoIscaPararEmergencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ComandoIscaPararEmergencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ComandoIscaCCID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ComandoIscaCCID $parameters
     * @return \StructType\ComandoIscaCCIDResponse|bool
     */
    public function ComandoIscaCCID(\StructType\ComandoIscaCCID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ComandoIscaCCID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ComandoIscaPreset
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ComandoIscaPreset $parameters
     * @return \StructType\ComandoIscaPresetResponse|bool
     */
    public function ComandoIscaPreset(\StructType\ComandoIscaPreset $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ComandoIscaPreset($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ComandoIscaConfigTempos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ComandoIscaConfigTempos $parameters
     * @return \StructType\ComandoIscaConfigTemposResponse|bool
     */
    public function ComandoIscaConfigTempos(\StructType\ComandoIscaConfigTempos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ComandoIscaConfigTempos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ComandoIscaCCIDResponse|\StructType\ComandoIscaConfigTemposResponse|\StructType\ComandoIscaIniciarEmergenciaResponse|\StructType\ComandoIscaPararEmergenciaResponse|\StructType\ComandoIscaPresetResponse|\StructType\ComandoLiberar5RodaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
