<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransmitirCfgMultiplosSensores StructType
 * Meta information extracted from the WSDL
 * - type: tns:TransmitirCfgMultiplosSensores
 * @subpackage Structs
 */
class TransmitirCfgMultiplosSensores extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdTerminal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdTerminal;
    /**
     * The IdConfig
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdConfig;
    /**
     * Constructor method for TransmitirCfgMultiplosSensores
     * @uses TransmitirCfgMultiplosSensores::setUsuario()
     * @uses TransmitirCfgMultiplosSensores::setSenha()
     * @uses TransmitirCfgMultiplosSensores::setIdTerminal()
     * @uses TransmitirCfgMultiplosSensores::setIdConfig()
     * @param string $usuario
     * @param string $senha
     * @param int $idTerminal
     * @param int $idConfig
     */
    public function __construct($usuario = null, $senha = null, $idTerminal = null, $idConfig = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdTerminal($idTerminal)
            ->setIdConfig($idConfig);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\TransmitirCfgMultiplosSensores
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\TransmitirCfgMultiplosSensores
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdTerminal value
     * @return int|null
     */
    public function getIdTerminal()
    {
        return $this->IdTerminal;
    }
    /**
     * Set IdTerminal value
     * @param int $idTerminal
     * @return \StructType\TransmitirCfgMultiplosSensores
     */
    public function setIdTerminal($idTerminal = null)
    {
        // validation for constraint: int
        if (!is_null($idTerminal) && !(is_int($idTerminal) || ctype_digit($idTerminal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idTerminal, true), gettype($idTerminal)), __LINE__);
        }
        $this->IdTerminal = $idTerminal;
        return $this;
    }
    /**
     * Get IdConfig value
     * @return int|null
     */
    public function getIdConfig()
    {
        return $this->IdConfig;
    }
    /**
     * Set IdConfig value
     * @param int $idConfig
     * @return \StructType\TransmitirCfgMultiplosSensores
     */
    public function setIdConfig($idConfig = null)
    {
        // validation for constraint: int
        if (!is_null($idConfig) && !(is_int($idConfig) || ctype_digit($idConfig))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idConfig, true), gettype($idConfig)), __LINE__);
        }
        $this->IdConfig = $idConfig;
        return $this;
    }
}
