<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PedeHistorico StructType
 * Meta information extracted from the WSDL
 * - type: tns:PedeHistorico
 * @subpackage Structs
 */
class PedeHistorico extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The idVeiculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $idVeiculo;
    /**
     * The IdOperacaoRemota
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdOperacaoRemota;
    /**
     * Constructor method for PedeHistorico
     * @uses PedeHistorico::setUsuario()
     * @uses PedeHistorico::setSenha()
     * @uses PedeHistorico::setIdVeiculo()
     * @uses PedeHistorico::setIdOperacaoRemota()
     * @param string $usuario
     * @param string $senha
     * @param string $idVeiculo
     * @param int $idOperacaoRemota
     */
    public function __construct($usuario = null, $senha = null, $idVeiculo = null, $idOperacaoRemota = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdVeiculo($idVeiculo)
            ->setIdOperacaoRemota($idOperacaoRemota);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\PedeHistorico
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\PedeHistorico
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get idVeiculo value
     * @return string|null
     */
    public function getIdVeiculo()
    {
        return $this->idVeiculo;
    }
    /**
     * Set idVeiculo value
     * @param string $idVeiculo
     * @return \StructType\PedeHistorico
     */
    public function setIdVeiculo($idVeiculo = null)
    {
        // validation for constraint: string
        if (!is_null($idVeiculo) && !is_string($idVeiculo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idVeiculo, true), gettype($idVeiculo)), __LINE__);
        }
        $this->idVeiculo = $idVeiculo;
        return $this;
    }
    /**
     * Get IdOperacaoRemota value
     * @return int|null
     */
    public function getIdOperacaoRemota()
    {
        return $this->IdOperacaoRemota;
    }
    /**
     * Set IdOperacaoRemota value
     * @param int $idOperacaoRemota
     * @return \StructType\PedeHistorico
     */
    public function setIdOperacaoRemota($idOperacaoRemota = null)
    {
        // validation for constraint: int
        if (!is_null($idOperacaoRemota) && !(is_int($idOperacaoRemota) || ctype_digit($idOperacaoRemota))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idOperacaoRemota, true), gettype($idOperacaoRemota)), __LINE__);
        }
        $this->IdOperacaoRemota = $idOperacaoRemota;
        return $this;
    }
}
