<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Operacao_Transmitir_Perfil StructType
 * Meta information extracted from the WSDL
 * - type: tns:Operacao_Transmitir_Perfil
 * @subpackage Structs
 */
class Operacao_Transmitir_Perfil extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdTerminal
     * @var int
     */
    public $IdTerminal;
    /**
     * The TipoConfiguracao
     * @var int
     */
    public $TipoConfiguracao;
    /**
     * Constructor method for Operacao_Transmitir_Perfil
     * @uses Operacao_Transmitir_Perfil::setUsuario()
     * @uses Operacao_Transmitir_Perfil::setSenha()
     * @uses Operacao_Transmitir_Perfil::setIdTerminal()
     * @uses Operacao_Transmitir_Perfil::setTipoConfiguracao()
     * @param string $usuario
     * @param string $senha
     * @param int $idTerminal
     * @param int $tipoConfiguracao
     */
    public function __construct($usuario = null, $senha = null, $idTerminal = null, $tipoConfiguracao = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdTerminal($idTerminal)
            ->setTipoConfiguracao($tipoConfiguracao);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\Operacao_Transmitir_Perfil
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\Operacao_Transmitir_Perfil
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdTerminal value
     * @return int|null
     */
    public function getIdTerminal()
    {
        return $this->IdTerminal;
    }
    /**
     * Set IdTerminal value
     * @param int $idTerminal
     * @return \StructType\Operacao_Transmitir_Perfil
     */
    public function setIdTerminal($idTerminal = null)
    {
        // validation for constraint: int
        if (!is_null($idTerminal) && !(is_int($idTerminal) || ctype_digit($idTerminal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idTerminal, true), gettype($idTerminal)), __LINE__);
        }
        $this->IdTerminal = $idTerminal;
        return $this;
    }
    /**
     * Get TipoConfiguracao value
     * @return int|null
     */
    public function getTipoConfiguracao()
    {
        return $this->TipoConfiguracao;
    }
    /**
     * Set TipoConfiguracao value
     * @param int $tipoConfiguracao
     * @return \StructType\Operacao_Transmitir_Perfil
     */
    public function setTipoConfiguracao($tipoConfiguracao = null)
    {
        // validation for constraint: int
        if (!is_null($tipoConfiguracao) && !(is_int($tipoConfiguracao) || ctype_digit($tipoConfiguracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipoConfiguracao, true), gettype($tipoConfiguracao)), __LINE__);
        }
        $this->TipoConfiguracao = $tipoConfiguracao;
        return $this;
    }
}
