<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObtemEventosImportacao StructType
 * Meta information extracted from the WSDL
 * - type: tns:ObtemEventosImportacao
 * @subpackage Structs
 */
class ObtemEventosImportacao extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The UltimoSeqCtrlImport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UltimoSeqCtrlImport;
    /**
     * Constructor method for ObtemEventosImportacao
     * @uses ObtemEventosImportacao::setUsuario()
     * @uses ObtemEventosImportacao::setSenha()
     * @uses ObtemEventosImportacao::setUltimoSeqCtrlImport()
     * @param string $usuario
     * @param string $senha
     * @param int $ultimoSeqCtrlImport
     */
    public function __construct($usuario = null, $senha = null, $ultimoSeqCtrlImport = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setUltimoSeqCtrlImport($ultimoSeqCtrlImport);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ObtemEventosImportacao
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ObtemEventosImportacao
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get UltimoSeqCtrlImport value
     * @return int|null
     */
    public function getUltimoSeqCtrlImport()
    {
        return $this->UltimoSeqCtrlImport;
    }
    /**
     * Set UltimoSeqCtrlImport value
     * @param int $ultimoSeqCtrlImport
     * @return \StructType\ObtemEventosImportacao
     */
    public function setUltimoSeqCtrlImport($ultimoSeqCtrlImport = null)
    {
        // validation for constraint: int
        if (!is_null($ultimoSeqCtrlImport) && !(is_int($ultimoSeqCtrlImport) || ctype_digit($ultimoSeqCtrlImport))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ultimoSeqCtrlImport, true), gettype($ultimoSeqCtrlImport)), __LINE__);
        }
        $this->UltimoSeqCtrlImport = $ultimoSeqCtrlImport;
        return $this;
    }
}
