<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListarVeiculosProximos StructType
 * Meta information extracted from the WSDL
 * - type: tns:ListarVeiculosProximos
 * @subpackage Structs
 */
class ListarVeiculosProximos extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The QuantMaxVeiculos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $QuantMaxVeiculos;
    /**
     * The DistanciaMaxima
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DistanciaMaxima;
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Longitude;
    /**
     * Constructor method for ListarVeiculosProximos
     * @uses ListarVeiculosProximos::setUsuario()
     * @uses ListarVeiculosProximos::setSenha()
     * @uses ListarVeiculosProximos::setQuantMaxVeiculos()
     * @uses ListarVeiculosProximos::setDistanciaMaxima()
     * @uses ListarVeiculosProximos::setLatitude()
     * @uses ListarVeiculosProximos::setLongitude()
     * @param string $usuario
     * @param string $senha
     * @param int $quantMaxVeiculos
     * @param int $distanciaMaxima
     * @param float $latitude
     * @param float $longitude
     */
    public function __construct($usuario = null, $senha = null, $quantMaxVeiculos = null, $distanciaMaxima = null, $latitude = null, $longitude = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setQuantMaxVeiculos($quantMaxVeiculos)
            ->setDistanciaMaxima($distanciaMaxima)
            ->setLatitude($latitude)
            ->setLongitude($longitude);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ListarVeiculosProximos
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ListarVeiculosProximos
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get QuantMaxVeiculos value
     * @return int|null
     */
    public function getQuantMaxVeiculos()
    {
        return $this->QuantMaxVeiculos;
    }
    /**
     * Set QuantMaxVeiculos value
     * @param int $quantMaxVeiculos
     * @return \StructType\ListarVeiculosProximos
     */
    public function setQuantMaxVeiculos($quantMaxVeiculos = null)
    {
        // validation for constraint: int
        if (!is_null($quantMaxVeiculos) && !(is_int($quantMaxVeiculos) || ctype_digit($quantMaxVeiculos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantMaxVeiculos, true), gettype($quantMaxVeiculos)), __LINE__);
        }
        $this->QuantMaxVeiculos = $quantMaxVeiculos;
        return $this;
    }
    /**
     * Get DistanciaMaxima value
     * @return int|null
     */
    public function getDistanciaMaxima()
    {
        return $this->DistanciaMaxima;
    }
    /**
     * Set DistanciaMaxima value
     * @param int $distanciaMaxima
     * @return \StructType\ListarVeiculosProximos
     */
    public function setDistanciaMaxima($distanciaMaxima = null)
    {
        // validation for constraint: int
        if (!is_null($distanciaMaxima) && !(is_int($distanciaMaxima) || ctype_digit($distanciaMaxima))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distanciaMaxima, true), gettype($distanciaMaxima)), __LINE__);
        }
        $this->DistanciaMaxima = $distanciaMaxima;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\ListarVeiculosProximos
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\ListarVeiculosProximos
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
}
