<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LacrarMotor StructType
 * Meta information extracted from the WSDL
 * - type: tns:LacrarMotor
 * @subpackage Structs
 */
class LacrarMotor extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The idVeiculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $idVeiculo;
    /**
     * The tempoLacreMotor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $tempoLacreMotor;
    /**
     * Constructor method for LacrarMotor
     * @uses LacrarMotor::setUsuario()
     * @uses LacrarMotor::setSenha()
     * @uses LacrarMotor::setIdVeiculo()
     * @uses LacrarMotor::setTempoLacreMotor()
     * @param string $usuario
     * @param string $senha
     * @param string $idVeiculo
     * @param int $tempoLacreMotor
     */
    public function __construct($usuario = null, $senha = null, $idVeiculo = null, $tempoLacreMotor = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdVeiculo($idVeiculo)
            ->setTempoLacreMotor($tempoLacreMotor);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\LacrarMotor
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\LacrarMotor
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get idVeiculo value
     * @return string|null
     */
    public function getIdVeiculo()
    {
        return $this->idVeiculo;
    }
    /**
     * Set idVeiculo value
     * @param string $idVeiculo
     * @return \StructType\LacrarMotor
     */
    public function setIdVeiculo($idVeiculo = null)
    {
        // validation for constraint: string
        if (!is_null($idVeiculo) && !is_string($idVeiculo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idVeiculo, true), gettype($idVeiculo)), __LINE__);
        }
        $this->idVeiculo = $idVeiculo;
        return $this;
    }
    /**
     * Get tempoLacreMotor value
     * @return int|null
     */
    public function getTempoLacreMotor()
    {
        return $this->tempoLacreMotor;
    }
    /**
     * Set tempoLacreMotor value
     * @param int $tempoLacreMotor
     * @return \StructType\LacrarMotor
     */
    public function setTempoLacreMotor($tempoLacreMotor = null)
    {
        // validation for constraint: int
        if (!is_null($tempoLacreMotor) && !(is_int($tempoLacreMotor) || ctype_digit($tempoLacreMotor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tempoLacreMotor, true), gettype($tempoLacreMotor)), __LINE__);
        }
        $this->tempoLacreMotor = $tempoLacreMotor;
        return $this;
    }
}
