<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcluirPerfilRota StructType
 * Meta information extracted from the WSDL
 * - type: tns:ExcluirPerfilRota
 * @subpackage Structs
 */
class ExcluirPerfilRota extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The idPerfilRota
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idPerfilRota;
    /**
     * Constructor method for ExcluirPerfilRota
     * @uses ExcluirPerfilRota::setUsuario()
     * @uses ExcluirPerfilRota::setSenha()
     * @uses ExcluirPerfilRota::setIdPerfilRota()
     * @param string $usuario
     * @param string $senha
     * @param int $idPerfilRota
     */
    public function __construct($usuario = null, $senha = null, $idPerfilRota = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdPerfilRota($idPerfilRota);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ExcluirPerfilRota
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ExcluirPerfilRota
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get idPerfilRota value
     * @return int|null
     */
    public function getIdPerfilRota()
    {
        return $this->idPerfilRota;
    }
    /**
     * Set idPerfilRota value
     * @param int $idPerfilRota
     * @return \StructType\ExcluirPerfilRota
     */
    public function setIdPerfilRota($idPerfilRota = null)
    {
        // validation for constraint: int
        if (!is_null($idPerfilRota) && !(is_int($idPerfilRota) || ctype_digit($idPerfilRota))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idPerfilRota, true), gettype($idPerfilRota)), __LINE__);
        }
        $this->idPerfilRota = $idPerfilRota;
        return $this;
    }
}
