<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcluirPerfilAlvo StructType
 * Meta information extracted from the WSDL
 * - type: tns:ExcluirPerfilAlvo
 * @subpackage Structs
 */
class ExcluirPerfilAlvo extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The idPerfilAlvo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idPerfilAlvo;
    /**
     * Constructor method for ExcluirPerfilAlvo
     * @uses ExcluirPerfilAlvo::setUsuario()
     * @uses ExcluirPerfilAlvo::setSenha()
     * @uses ExcluirPerfilAlvo::setIdPerfilAlvo()
     * @param string $usuario
     * @param string $senha
     * @param int $idPerfilAlvo
     */
    public function __construct($usuario = null, $senha = null, $idPerfilAlvo = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdPerfilAlvo($idPerfilAlvo);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ExcluirPerfilAlvo
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ExcluirPerfilAlvo
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get idPerfilAlvo value
     * @return int|null
     */
    public function getIdPerfilAlvo()
    {
        return $this->idPerfilAlvo;
    }
    /**
     * Set idPerfilAlvo value
     * @param int $idPerfilAlvo
     * @return \StructType\ExcluirPerfilAlvo
     */
    public function setIdPerfilAlvo($idPerfilAlvo = null)
    {
        // validation for constraint: int
        if (!is_null($idPerfilAlvo) && !(is_int($idPerfilAlvo) || ctype_digit($idPerfilAlvo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idPerfilAlvo, true), gettype($idPerfilAlvo)), __LINE__);
        }
        $this->idPerfilAlvo = $idPerfilAlvo;
        return $this;
    }
}
