<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcluirOperacao StructType
 * Meta information extracted from the WSDL
 * - type: tns:ExcluirOperacao
 * @subpackage Structs
 */
class ExcluirOperacao extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdOperacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdOperacao;
    /**
     * Constructor method for ExcluirOperacao
     * @uses ExcluirOperacao::setUsuario()
     * @uses ExcluirOperacao::setSenha()
     * @uses ExcluirOperacao::setIdOperacao()
     * @param string $usuario
     * @param string $senha
     * @param int $idOperacao
     */
    public function __construct($usuario = null, $senha = null, $idOperacao = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdOperacao($idOperacao);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ExcluirOperacao
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ExcluirOperacao
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdOperacao value
     * @return int|null
     */
    public function getIdOperacao()
    {
        return $this->IdOperacao;
    }
    /**
     * Set IdOperacao value
     * @param int $idOperacao
     * @return \StructType\ExcluirOperacao
     */
    public function setIdOperacao($idOperacao = null)
    {
        // validation for constraint: int
        if (!is_null($idOperacao) && !(is_int($idOperacao) || ctype_digit($idOperacao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idOperacao, true), gettype($idOperacao)), __LINE__);
        }
        $this->IdOperacao = $idOperacao;
        return $this;
    }
}
