<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcluirGrupoCerca StructType
 * Meta information extracted from the WSDL
 * - type: tns:ExcluirGrupoCerca
 * @subpackage Structs
 */
class ExcluirGrupoCerca extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The idGrupoCerca
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idGrupoCerca;
    /**
     * Constructor method for ExcluirGrupoCerca
     * @uses ExcluirGrupoCerca::setUsuario()
     * @uses ExcluirGrupoCerca::setSenha()
     * @uses ExcluirGrupoCerca::setIdGrupoCerca()
     * @param string $usuario
     * @param string $senha
     * @param int $idGrupoCerca
     */
    public function __construct($usuario = null, $senha = null, $idGrupoCerca = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdGrupoCerca($idGrupoCerca);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ExcluirGrupoCerca
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ExcluirGrupoCerca
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get idGrupoCerca value
     * @return int|null
     */
    public function getIdGrupoCerca()
    {
        return $this->idGrupoCerca;
    }
    /**
     * Set idGrupoCerca value
     * @param int $idGrupoCerca
     * @return \StructType\ExcluirGrupoCerca
     */
    public function setIdGrupoCerca($idGrupoCerca = null)
    {
        // validation for constraint: int
        if (!is_null($idGrupoCerca) && !(is_int($idGrupoCerca) || ctype_digit($idGrupoCerca))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idGrupoCerca, true), gettype($idGrupoCerca)), __LINE__);
        }
        $this->idGrupoCerca = $idGrupoCerca;
        return $this;
    }
}
