<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditarOperacao StructType
 * Meta information extracted from the WSDL
 * - type: tns:EditarOperacao
 * @subpackage Structs
 */
class EditarOperacao extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdOperacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdOperacao;
    /**
     * The Nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Nome;
    /**
     * The TipoAlvo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TipoAlvo;
    /**
     * The Persistencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Persistencia;
    /**
     * The EmSobreposicao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EmSobreposicao;
    /**
     * Constructor method for EditarOperacao
     * @uses EditarOperacao::setUsuario()
     * @uses EditarOperacao::setSenha()
     * @uses EditarOperacao::setIdOperacao()
     * @uses EditarOperacao::setNome()
     * @uses EditarOperacao::setTipoAlvo()
     * @uses EditarOperacao::setPersistencia()
     * @uses EditarOperacao::setEmSobreposicao()
     * @param string $usuario
     * @param string $senha
     * @param int $idOperacao
     * @param string $nome
     * @param int $tipoAlvo
     * @param int $persistencia
     * @param int $emSobreposicao
     */
    public function __construct($usuario = null, $senha = null, $idOperacao = null, $nome = null, $tipoAlvo = null, $persistencia = null, $emSobreposicao = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdOperacao($idOperacao)
            ->setNome($nome)
            ->setTipoAlvo($tipoAlvo)
            ->setPersistencia($persistencia)
            ->setEmSobreposicao($emSobreposicao);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\EditarOperacao
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\EditarOperacao
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdOperacao value
     * @return int|null
     */
    public function getIdOperacao()
    {
        return $this->IdOperacao;
    }
    /**
     * Set IdOperacao value
     * @param int $idOperacao
     * @return \StructType\EditarOperacao
     */
    public function setIdOperacao($idOperacao = null)
    {
        // validation for constraint: int
        if (!is_null($idOperacao) && !(is_int($idOperacao) || ctype_digit($idOperacao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idOperacao, true), gettype($idOperacao)), __LINE__);
        }
        $this->IdOperacao = $idOperacao;
        return $this;
    }
    /**
     * Get Nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->Nome;
    }
    /**
     * Set Nome value
     * @param string $nome
     * @return \StructType\EditarOperacao
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->Nome = $nome;
        return $this;
    }
    /**
     * Get TipoAlvo value
     * @return int|null
     */
    public function getTipoAlvo()
    {
        return $this->TipoAlvo;
    }
    /**
     * Set TipoAlvo value
     * @param int $tipoAlvo
     * @return \StructType\EditarOperacao
     */
    public function setTipoAlvo($tipoAlvo = null)
    {
        // validation for constraint: int
        if (!is_null($tipoAlvo) && !(is_int($tipoAlvo) || ctype_digit($tipoAlvo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipoAlvo, true), gettype($tipoAlvo)), __LINE__);
        }
        $this->TipoAlvo = $tipoAlvo;
        return $this;
    }
    /**
     * Get Persistencia value
     * @return int|null
     */
    public function getPersistencia()
    {
        return $this->Persistencia;
    }
    /**
     * Set Persistencia value
     * @param int $persistencia
     * @return \StructType\EditarOperacao
     */
    public function setPersistencia($persistencia = null)
    {
        // validation for constraint: int
        if (!is_null($persistencia) && !(is_int($persistencia) || ctype_digit($persistencia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($persistencia, true), gettype($persistencia)), __LINE__);
        }
        $this->Persistencia = $persistencia;
        return $this;
    }
    /**
     * Get EmSobreposicao value
     * @return int|null
     */
    public function getEmSobreposicao()
    {
        return $this->EmSobreposicao;
    }
    /**
     * Set EmSobreposicao value
     * @param int $emSobreposicao
     * @return \StructType\EditarOperacao
     */
    public function setEmSobreposicao($emSobreposicao = null)
    {
        // validation for constraint: int
        if (!is_null($emSobreposicao) && !(is_int($emSobreposicao) || ctype_digit($emSobreposicao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($emSobreposicao, true), gettype($emSobreposicao)), __LINE__);
        }
        $this->EmSobreposicao = $emSobreposicao;
        return $this;
    }
}
