<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CadastrarOperacao StructType
 * Meta information extracted from the WSDL
 * - type: tns:CadastrarOperacao
 * @subpackage Structs
 */
class CadastrarOperacao extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The Nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Nome;
    /**
     * The TipoAlvos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TipoAlvos;
    /**
     * The Persistencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Persistencia;
    /**
     * The EmSobreposicao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EmSobreposicao;
    /**
     * Constructor method for CadastrarOperacao
     * @uses CadastrarOperacao::setUsuario()
     * @uses CadastrarOperacao::setSenha()
     * @uses CadastrarOperacao::setNome()
     * @uses CadastrarOperacao::setTipoAlvos()
     * @uses CadastrarOperacao::setPersistencia()
     * @uses CadastrarOperacao::setEmSobreposicao()
     * @param string $usuario
     * @param string $senha
     * @param string $nome
     * @param int $tipoAlvos
     * @param int $persistencia
     * @param int $emSobreposicao
     */
    public function __construct($usuario = null, $senha = null, $nome = null, $tipoAlvos = null, $persistencia = null, $emSobreposicao = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setNome($nome)
            ->setTipoAlvos($tipoAlvos)
            ->setPersistencia($persistencia)
            ->setEmSobreposicao($emSobreposicao);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\CadastrarOperacao
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\CadastrarOperacao
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get Nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->Nome;
    }
    /**
     * Set Nome value
     * @param string $nome
     * @return \StructType\CadastrarOperacao
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->Nome = $nome;
        return $this;
    }
    /**
     * Get TipoAlvos value
     * @return int|null
     */
    public function getTipoAlvos()
    {
        return $this->TipoAlvos;
    }
    /**
     * Set TipoAlvos value
     * @param int $tipoAlvos
     * @return \StructType\CadastrarOperacao
     */
    public function setTipoAlvos($tipoAlvos = null)
    {
        // validation for constraint: int
        if (!is_null($tipoAlvos) && !(is_int($tipoAlvos) || ctype_digit($tipoAlvos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipoAlvos, true), gettype($tipoAlvos)), __LINE__);
        }
        $this->TipoAlvos = $tipoAlvos;
        return $this;
    }
    /**
     * Get Persistencia value
     * @return int|null
     */
    public function getPersistencia()
    {
        return $this->Persistencia;
    }
    /**
     * Set Persistencia value
     * @param int $persistencia
     * @return \StructType\CadastrarOperacao
     */
    public function setPersistencia($persistencia = null)
    {
        // validation for constraint: int
        if (!is_null($persistencia) && !(is_int($persistencia) || ctype_digit($persistencia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($persistencia, true), gettype($persistencia)), __LINE__);
        }
        $this->Persistencia = $persistencia;
        return $this;
    }
    /**
     * Get EmSobreposicao value
     * @return int|null
     */
    public function getEmSobreposicao()
    {
        return $this->EmSobreposicao;
    }
    /**
     * Set EmSobreposicao value
     * @param int $emSobreposicao
     * @return \StructType\CadastrarOperacao
     */
    public function setEmSobreposicao($emSobreposicao = null)
    {
        // validation for constraint: int
        if (!is_null($emSobreposicao) && !(is_int($emSobreposicao) || ctype_digit($emSobreposicao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($emSobreposicao, true), gettype($emSobreposicao)), __LINE__);
        }
        $this->EmSobreposicao = $emSobreposicao;
        return $this;
    }
}
