<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CadastrarClasseDeReferencia StructType
 * Meta information extracted from the WSDL
 * - type: tns:CadastrarClasseDeReferencia
 * @subpackage Structs
 */
class CadastrarClasseDeReferencia extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The Nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Nome;
    /**
     * The Figura
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Figura;
    /**
     * The Visivel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Visivel;
    /**
     * Constructor method for CadastrarClasseDeReferencia
     * @uses CadastrarClasseDeReferencia::setUsuario()
     * @uses CadastrarClasseDeReferencia::setSenha()
     * @uses CadastrarClasseDeReferencia::setNome()
     * @uses CadastrarClasseDeReferencia::setFigura()
     * @uses CadastrarClasseDeReferencia::setVisivel()
     * @param string $usuario
     * @param string $senha
     * @param string $nome
     * @param string $figura
     * @param int $visivel
     */
    public function __construct($usuario = null, $senha = null, $nome = null, $figura = null, $visivel = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setNome($nome)
            ->setFigura($figura)
            ->setVisivel($visivel);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\CadastrarClasseDeReferencia
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\CadastrarClasseDeReferencia
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get Nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->Nome;
    }
    /**
     * Set Nome value
     * @param string $nome
     * @return \StructType\CadastrarClasseDeReferencia
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->Nome = $nome;
        return $this;
    }
    /**
     * Get Figura value
     * @return string|null
     */
    public function getFigura()
    {
        return $this->Figura;
    }
    /**
     * Set Figura value
     * @param string $figura
     * @return \StructType\CadastrarClasseDeReferencia
     */
    public function setFigura($figura = null)
    {
        // validation for constraint: string
        if (!is_null($figura) && !is_string($figura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($figura, true), gettype($figura)), __LINE__);
        }
        $this->Figura = $figura;
        return $this;
    }
    /**
     * Get Visivel value
     * @return int|null
     */
    public function getVisivel()
    {
        return $this->Visivel;
    }
    /**
     * Set Visivel value
     * @param int $visivel
     * @return \StructType\CadastrarClasseDeReferencia
     */
    public function setVisivel($visivel = null)
    {
        // validation for constraint: int
        if (!is_null($visivel) && !(is_int($visivel) || ctype_digit($visivel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($visivel, true), gettype($visivel)), __LINE__);
        }
        $this->Visivel = $visivel;
        return $this;
    }
}
